package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReferenceGrantListBuilder extends ReferenceGrantListFluentImpl<ReferenceGrantListBuilder> implements VisitableBuilder<ReferenceGrantList,ReferenceGrantListBuilder>{
  public ReferenceGrantListBuilder() {
    this(false);
  }
  public ReferenceGrantListBuilder(Boolean validationEnabled) {
    this(new ReferenceGrantList(), validationEnabled);
  }
  public ReferenceGrantListBuilder(ReferenceGrantListFluent<?> fluent) {
    this(fluent, false);
  }
  public ReferenceGrantListBuilder(ReferenceGrantListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReferenceGrantList(), validationEnabled);
  }
  public ReferenceGrantListBuilder(ReferenceGrantListFluent<?> fluent,ReferenceGrantList instance) {
    this(fluent, instance, false);
  }
  public ReferenceGrantListBuilder(ReferenceGrantListFluent<?> fluent,ReferenceGrantList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReferenceGrantListBuilder(ReferenceGrantList instance) {
    this(instance,false);
  }
  public ReferenceGrantListBuilder(ReferenceGrantList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReferenceGrantListFluent<?> fluent;
  Boolean validationEnabled;
  public ReferenceGrantList build() {
    ReferenceGrantList buildable = new ReferenceGrantList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}