package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCRouteMatchBuilder extends GRPCRouteMatchFluentImpl<GRPCRouteMatchBuilder> implements VisitableBuilder<GRPCRouteMatch,GRPCRouteMatchBuilder>{
  public GRPCRouteMatchBuilder() {
    this(false);
  }
  public GRPCRouteMatchBuilder(Boolean validationEnabled) {
    this(new GRPCRouteMatch(), validationEnabled);
  }
  public GRPCRouteMatchBuilder(GRPCRouteMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCRouteMatchBuilder(GRPCRouteMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCRouteMatch(), validationEnabled);
  }
  public GRPCRouteMatchBuilder(GRPCRouteMatchFluent<?> fluent,GRPCRouteMatch instance) {
    this(fluent, instance, false);
  }
  public GRPCRouteMatchBuilder(GRPCRouteMatchFluent<?> fluent,GRPCRouteMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHeaders(instance.getHeaders());
      fluent.withMethod(instance.getMethod());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GRPCRouteMatchBuilder(GRPCRouteMatch instance) {
    this(instance,false);
  }
  public GRPCRouteMatchBuilder(GRPCRouteMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHeaders(instance.getHeaders());
      this.withMethod(instance.getMethod());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GRPCRouteMatchFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCRouteMatch build() {
    GRPCRouteMatch buildable = new GRPCRouteMatch(fluent.getHeaders(),fluent.getMethod());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}