package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UDPRouteRuleBuilder extends UDPRouteRuleFluentImpl<UDPRouteRuleBuilder> implements VisitableBuilder<UDPRouteRule,UDPRouteRuleBuilder>{
  public UDPRouteRuleBuilder() {
    this(false);
  }
  public UDPRouteRuleBuilder(Boolean validationEnabled) {
    this(new UDPRouteRule(), validationEnabled);
  }
  public UDPRouteRuleBuilder(UDPRouteRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public UDPRouteRuleBuilder(UDPRouteRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UDPRouteRule(), validationEnabled);
  }
  public UDPRouteRuleBuilder(UDPRouteRuleFluent<?> fluent,UDPRouteRule instance) {
    this(fluent, instance, false);
  }
  public UDPRouteRuleBuilder(UDPRouteRuleFluent<?> fluent,UDPRouteRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackendRefs(instance.getBackendRefs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UDPRouteRuleBuilder(UDPRouteRule instance) {
    this(instance,false);
  }
  public UDPRouteRuleBuilder(UDPRouteRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackendRefs(instance.getBackendRefs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UDPRouteRuleFluent<?> fluent;
  Boolean validationEnabled;
  public UDPRouteRule build() {
    UDPRouteRule buildable = new UDPRouteRule(fluent.getBackendRefs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}