package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GRPCBackendRefFluentImpl<A extends GRPCBackendRefFluent<A>> extends BaseFluent<A> implements GRPCBackendRefFluent<A>{
  public GRPCBackendRefFluentImpl() {
  }
  public GRPCBackendRefFluentImpl(GRPCBackendRef instance) {
    this.withFilters(instance.getFilters()); 
    this.withGroup(instance.getGroup()); 
    this.withKind(instance.getKind()); 
    this.withName(instance.getName()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPort(instance.getPort()); 
    this.withWeight(instance.getWeight()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList<GRPCRouteFilterBuilder>();
  private String group;
  private String kind;
  private String name;
  private String namespace;
  private Integer port;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  public A addToFilters(Integer index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(index >= 0 ? index : _visitables.get("filters").size(), builder);this.filters.add(index >= 0 ? index : filters.size(), builder); return (A)this;
  }
  public A setToFilters(Integer index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
    if (index < 0 || index >= _visitables.get("filters").size()) { _visitables.get("filters").add(builder); } else { _visitables.get("filters").set(index, builder);}
    if (index < 0 || index >= filters.size()) { filters.add(builder); } else { filters.set(index, builder);}
     return (A)this;
  }
  public A addToFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A addAllToFilters(Collection<GRPCRouteFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  public A removeFromFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder);if (this.filters != null) {this.filters.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<GRPCRouteFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      GRPCRouteFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFilters instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GRPCRouteFilter> getFilters() {
    return filters != null ? build(filters) : null;
  }
  public List<GRPCRouteFilter> buildFilters() {
    return filters != null ? build(filters) : null;
  }
  public GRPCRouteFilter buildFilter(Integer index) {
    return this.filters.get(index).build();
  }
  public GRPCRouteFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  public GRPCRouteFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    for (GRPCRouteFilterBuilder item: filters) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    for (GRPCRouteFilterBuilder item: filters) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFilters(List<GRPCRouteFilter> filters) {
    if (this.filters != null) { _visitables.get("filters").removeAll(this.filters);}
    if (filters != null) {this.filters = new ArrayList(); for (GRPCRouteFilter item : filters){this.addToFilters(item);}} else { this.filters = null;} return (A) this;
  }
  public A withFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... filters) {
    if (this.filters != null) {this.filters.clear();}
    if (filters != null) {for (GRPCRouteFilter item :filters){ this.addToFilters(item);}} return (A) this;
  }
  public Boolean hasFilters() {
    return filters != null && !filters.isEmpty();
  }
  public GRPCBackendRefFluent.FiltersNested<A> addNewFilter() {
    return new GRPCBackendRefFluentImpl.FiltersNestedImpl();
  }
  public GRPCBackendRefFluent.FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
    return new GRPCBackendRefFluentImpl.FiltersNestedImpl(-1, item);
  }
  public GRPCBackendRefFluent.FiltersNested<A> setNewFilterLike(Integer index,GRPCRouteFilter item) {
    return new GRPCBackendRefFluentImpl.FiltersNestedImpl(index, item);
  }
  public GRPCBackendRefFluent.FiltersNested<A> editFilter(Integer index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public GRPCBackendRefFluent.FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  public GRPCBackendRefFluent.FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public GRPCBackendRefFluent.FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public Boolean hasGroup() {
    return this.group != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public String getNamespace() {
    return this.namespace;
  }
  public A withNamespace(String namespace) {
    this.namespace=namespace; return (A) this;
  }
  public Boolean hasNamespace() {
    return this.namespace != null;
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public Integer getWeight() {
    return this.weight;
  }
  public A withWeight(Integer weight) {
    this.weight=weight; return (A) this;
  }
  public Boolean hasWeight() {
    return this.weight != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GRPCBackendRefFluentImpl that = (GRPCBackendRefFluentImpl) o;
    if (filters != null ? !filters.equals(that.filters) :that.filters != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(filters,  group,  kind,  name,  namespace,  port,  weight,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class FiltersNestedImpl<N> extends GRPCRouteFilterFluentImpl<GRPCBackendRefFluent.FiltersNested<N>> implements GRPCBackendRefFluent.FiltersNested<N>,Nested<N>{
    FiltersNestedImpl(Integer index,GRPCRouteFilter item) {
      this.index = index;
      this.builder = new GRPCRouteFilterBuilder(this, item);
    }
    FiltersNestedImpl() {
      this.index = -1;
      this.builder = new GRPCRouteFilterBuilder(this);
    }
    GRPCRouteFilterBuilder builder;
    Integer index;
    public N and() {
      return (N) GRPCBackendRefFluentImpl.this.setToFilters(index,builder.build());
    }
    public N endFilter() {
      return and();
    }
    
  }
  
}