package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCMethodMatchBuilder extends GRPCMethodMatchFluentImpl<GRPCMethodMatchBuilder> implements VisitableBuilder<GRPCMethodMatch,GRPCMethodMatchBuilder>{
  public GRPCMethodMatchBuilder() {
    this(false);
  }
  public GRPCMethodMatchBuilder(Boolean validationEnabled) {
    this(new GRPCMethodMatch(), validationEnabled);
  }
  public GRPCMethodMatchBuilder(GRPCMethodMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCMethodMatchBuilder(GRPCMethodMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCMethodMatch(), validationEnabled);
  }
  public GRPCMethodMatchBuilder(GRPCMethodMatchFluent<?> fluent,GRPCMethodMatch instance) {
    this(fluent, instance, false);
  }
  public GRPCMethodMatchBuilder(GRPCMethodMatchFluent<?> fluent,GRPCMethodMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMethod(instance.getMethod()); 
    fluent.withService(instance.getService()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GRPCMethodMatchBuilder(GRPCMethodMatch instance) {
    this(instance,false);
  }
  public GRPCMethodMatchBuilder(GRPCMethodMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMethod(instance.getMethod()); 
    this.withService(instance.getService()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GRPCMethodMatchFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCMethodMatch build() {
    GRPCMethodMatch buildable = new GRPCMethodMatch(fluent.getMethod(),fluent.getService(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}