package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GRPCHeaderMatchBuilder extends GRPCHeaderMatchFluentImpl<GRPCHeaderMatchBuilder> implements VisitableBuilder<GRPCHeaderMatch,GRPCHeaderMatchBuilder>{
  public GRPCHeaderMatchBuilder() {
    this(false);
  }
  public GRPCHeaderMatchBuilder(Boolean validationEnabled) {
    this(new GRPCHeaderMatch(), validationEnabled);
  }
  public GRPCHeaderMatchBuilder(GRPCHeaderMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public GRPCHeaderMatchBuilder(GRPCHeaderMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GRPCHeaderMatch(), validationEnabled);
  }
  public GRPCHeaderMatchBuilder(GRPCHeaderMatchFluent<?> fluent,GRPCHeaderMatch instance) {
    this(fluent, instance, false);
  }
  public GRPCHeaderMatchBuilder(GRPCHeaderMatchFluent<?> fluent,GRPCHeaderMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GRPCHeaderMatchBuilder(GRPCHeaderMatch instance) {
    this(instance,false);
  }
  public GRPCHeaderMatchBuilder(GRPCHeaderMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GRPCHeaderMatchFluent<?> fluent;
  Boolean validationEnabled;
  public GRPCHeaderMatch build() {
    GRPCHeaderMatch buildable = new GRPCHeaderMatch(fluent.getName(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}