package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AllowedRoutesFluentImpl<A extends AllowedRoutesFluent<A>> extends BaseFluent<A> implements AllowedRoutesFluent<A>{
  public AllowedRoutesFluentImpl() {
  }
  public AllowedRoutesFluentImpl(AllowedRoutes instance) {
    this.withKinds(instance.getKinds()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<RouteGroupKindBuilder> kinds = new ArrayList<RouteGroupKindBuilder>();
  private RouteNamespacesBuilder namespaces;
  private Map<String,Object> additionalProperties;
  public A addToKinds(Integer index,RouteGroupKind item) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").add(index >= 0 ? index : _visitables.get("kinds").size(), builder);this.kinds.add(index >= 0 ? index : kinds.size(), builder); return (A)this;
  }
  public A setToKinds(Integer index,RouteGroupKind item) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
    if (index < 0 || index >= _visitables.get("kinds").size()) { _visitables.get("kinds").add(builder); } else { _visitables.get("kinds").set(index, builder);}
    if (index < 0 || index >= kinds.size()) { kinds.add(builder); } else { kinds.set(index, builder);}
     return (A)this;
  }
  public A addToKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... items) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").add(builder);this.kinds.add(builder);} return (A)this;
  }
  public A addAllToKinds(Collection<RouteGroupKind> items) {
    if (this.kinds == null) {this.kinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").add(builder);this.kinds.add(builder);} return (A)this;
  }
  public A removeFromKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... items) {
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").remove(builder);if (this.kinds != null) {this.kinds.remove(builder);}} return (A)this;
  }
  public A removeAllFromKinds(Collection<RouteGroupKind> items) {
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("kinds").remove(builder);if (this.kinds != null) {this.kinds.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromKinds(Predicate<RouteGroupKindBuilder> predicate) {
    if (kinds == null) return (A) this;
    final Iterator<RouteGroupKindBuilder> each = kinds.iterator();
    final List visitables = _visitables.get("kinds");
    while (each.hasNext()) {
      RouteGroupKindBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildKinds instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RouteGroupKind> getKinds() {
    return kinds != null ? build(kinds) : null;
  }
  public List<RouteGroupKind> buildKinds() {
    return kinds != null ? build(kinds) : null;
  }
  public RouteGroupKind buildKind(Integer index) {
    return this.kinds.get(index).build();
  }
  public RouteGroupKind buildFirstKind() {
    return this.kinds.get(0).build();
  }
  public RouteGroupKind buildLastKind() {
    return this.kinds.get(kinds.size() - 1).build();
  }
  public RouteGroupKind buildMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: kinds) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: kinds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withKinds(List<RouteGroupKind> kinds) {
    if (this.kinds != null) { _visitables.get("kinds").removeAll(this.kinds);}
    if (kinds != null) {this.kinds = new ArrayList(); for (RouteGroupKind item : kinds){this.addToKinds(item);}} else { this.kinds = null;} return (A) this;
  }
  public A withKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.RouteGroupKind... kinds) {
    if (this.kinds != null) {this.kinds.clear();}
    if (kinds != null) {for (RouteGroupKind item :kinds){ this.addToKinds(item);}} return (A) this;
  }
  public Boolean hasKinds() {
    return kinds != null && !kinds.isEmpty();
  }
  public A addNewKind(String group,String kind) {
    return (A)addToKinds(new RouteGroupKind(group, kind));
  }
  public AllowedRoutesFluent.KindsNested<A> addNewKind() {
    return new AllowedRoutesFluentImpl.KindsNestedImpl();
  }
  public AllowedRoutesFluent.KindsNested<A> addNewKindLike(RouteGroupKind item) {
    return new AllowedRoutesFluentImpl.KindsNestedImpl(-1, item);
  }
  public AllowedRoutesFluent.KindsNested<A> setNewKindLike(Integer index,RouteGroupKind item) {
    return new AllowedRoutesFluentImpl.KindsNestedImpl(index, item);
  }
  public AllowedRoutesFluent.KindsNested<A> editKind(Integer index) {
    if (kinds.size() <= index) throw new RuntimeException("Can't edit kinds. Index exceeds size.");
    return setNewKindLike(index, buildKind(index));
  }
  public AllowedRoutesFluent.KindsNested<A> editFirstKind() {
    if (kinds.size() == 0) throw new RuntimeException("Can't edit first kinds. The list is empty.");
    return setNewKindLike(0, buildKind(0));
  }
  public AllowedRoutesFluent.KindsNested<A> editLastKind() {
    int index = kinds.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last kinds. The list is empty.");
    return setNewKindLike(index, buildKind(index));
  }
  public AllowedRoutesFluent.KindsNested<A> editMatchingKind(Predicate<RouteGroupKindBuilder> predicate) {
    int index = -1;
    for (int i=0;i<kinds.size();i++) { 
    if (predicate.test(kinds.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching kinds. No match found.");
    return setNewKindLike(index, buildKind(index));
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaces instead.
   * @return The buildable object.
   */
  @Deprecated
  public RouteNamespaces getNamespaces() {
    return this.namespaces!=null ?this.namespaces.build():null;
  }
  public RouteNamespaces buildNamespaces() {
    return this.namespaces!=null ?this.namespaces.build():null;
  }
  public A withNamespaces(RouteNamespaces namespaces) {
    _visitables.get("namespaces").remove(this.namespaces);
    if (namespaces!=null){ this.namespaces= new RouteNamespacesBuilder(namespaces); _visitables.get("namespaces").add(this.namespaces);} else { this.namespaces = null; _visitables.get("namespaces").remove(this.namespaces); } return (A) this;
  }
  public Boolean hasNamespaces() {
    return this.namespaces != null;
  }
  public AllowedRoutesFluent.NamespacesNested<A> withNewNamespaces() {
    return new AllowedRoutesFluentImpl.NamespacesNestedImpl();
  }
  public AllowedRoutesFluent.NamespacesNested<A> withNewNamespacesLike(RouteNamespaces item) {
    return new AllowedRoutesFluentImpl.NamespacesNestedImpl(item);
  }
  public AllowedRoutesFluent.NamespacesNested<A> editNamespaces() {
    return withNewNamespacesLike(getNamespaces());
  }
  public AllowedRoutesFluent.NamespacesNested<A> editOrNewNamespaces() {
    return withNewNamespacesLike(getNamespaces() != null ? getNamespaces(): new RouteNamespacesBuilder().build());
  }
  public AllowedRoutesFluent.NamespacesNested<A> editOrNewNamespacesLike(RouteNamespaces item) {
    return withNewNamespacesLike(getNamespaces() != null ? getNamespaces(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    AllowedRoutesFluentImpl that = (AllowedRoutesFluentImpl) o;
    if (kinds != null ? !kinds.equals(that.kinds) :that.kinds != null) return false;
    if (namespaces != null ? !namespaces.equals(that.namespaces) :that.namespaces != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(kinds,  namespaces,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (kinds != null && !kinds.isEmpty()) { sb.append("kinds:"); sb.append(kinds + ","); }
    if (namespaces != null) { sb.append("namespaces:"); sb.append(namespaces + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class KindsNestedImpl<N> extends RouteGroupKindFluentImpl<AllowedRoutesFluent.KindsNested<N>> implements AllowedRoutesFluent.KindsNested<N>,Nested<N>{
    KindsNestedImpl(Integer index,RouteGroupKind item) {
      this.index = index;
      this.builder = new RouteGroupKindBuilder(this, item);
    }
    KindsNestedImpl() {
      this.index = -1;
      this.builder = new RouteGroupKindBuilder(this);
    }
    RouteGroupKindBuilder builder;
    Integer index;
    public N and() {
      return (N) AllowedRoutesFluentImpl.this.setToKinds(index,builder.build());
    }
    public N endKind() {
      return and();
    }
    
  }
  class NamespacesNestedImpl<N> extends RouteNamespacesFluentImpl<AllowedRoutesFluent.NamespacesNested<N>> implements AllowedRoutesFluent.NamespacesNested<N>,Nested<N>{
    NamespacesNestedImpl(RouteNamespaces item) {
      this.builder = new RouteNamespacesBuilder(this, item);
    }
    NamespacesNestedImpl() {
      this.builder = new RouteNamespacesBuilder(this);
    }
    RouteNamespacesBuilder builder;
    public N and() {
      return (N) AllowedRoutesFluentImpl.this.withNamespaces(builder.build());
    }
    public N endNamespaces() {
      return and();
    }
    
  }
  
}