package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayTLSConfigBuilder extends GatewayTLSConfigFluentImpl<GatewayTLSConfigBuilder> implements VisitableBuilder<GatewayTLSConfig,GatewayTLSConfigBuilder>{
  public GatewayTLSConfigBuilder() {
    this(false);
  }
  public GatewayTLSConfigBuilder(Boolean validationEnabled) {
    this(new GatewayTLSConfig(), validationEnabled);
  }
  public GatewayTLSConfigBuilder(GatewayTLSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayTLSConfigBuilder(GatewayTLSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayTLSConfig(), validationEnabled);
  }
  public GatewayTLSConfigBuilder(GatewayTLSConfigFluent<?> fluent,GatewayTLSConfig instance) {
    this(fluent, instance, false);
  }
  public GatewayTLSConfigBuilder(GatewayTLSConfigFluent<?> fluent,GatewayTLSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCertificateRefs(instance.getCertificateRefs()); 
    fluent.withMode(instance.getMode()); 
    fluent.withOptions(instance.getOptions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GatewayTLSConfigBuilder(GatewayTLSConfig instance) {
    this(instance,false);
  }
  public GatewayTLSConfigBuilder(GatewayTLSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withCertificateRefs(instance.getCertificateRefs()); 
    this.withMode(instance.getMode()); 
    this.withOptions(instance.getOptions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GatewayTLSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayTLSConfig build() {
    GatewayTLSConfig buildable = new GatewayTLSConfig(fluent.getCertificateRefs(),fluent.getMode(),fluent.getOptions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}