package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ListenerStatusFluentImpl<A extends ListenerStatusFluent<A>> extends BaseFluent<A> implements ListenerStatusFluent<A>{
  public ListenerStatusFluentImpl() {
  }
  public ListenerStatusFluentImpl(ListenerStatus instance) {
    this.withAttachedRoutes(instance.getAttachedRoutes()); 
    this.withConditions(instance.getConditions()); 
    this.withName(instance.getName()); 
    this.withSupportedKinds(instance.getSupportedKinds()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer attachedRoutes;
  private List<Condition> conditions = new ArrayList<Condition>();
  private String name;
  private ArrayList<RouteGroupKindBuilder> supportedKinds = new ArrayList<RouteGroupKindBuilder>();
  private Map<String,Object> additionalProperties;
  public Integer getAttachedRoutes() {
    return this.attachedRoutes;
  }
  public A withAttachedRoutes(Integer attachedRoutes) {
    this.attachedRoutes=attachedRoutes; return (A) this;
  }
  public Boolean hasAttachedRoutes() {
    return this.attachedRoutes != null;
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public A addToSupportedKinds(Integer index,RouteGroupKind item) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").add(index >= 0 ? index : _visitables.get("supportedKinds").size(), builder);this.supportedKinds.add(index >= 0 ? index : supportedKinds.size(), builder); return (A)this;
  }
  public A setToSupportedKinds(Integer index,RouteGroupKind item) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);
    if (index < 0 || index >= _visitables.get("supportedKinds").size()) { _visitables.get("supportedKinds").add(builder); } else { _visitables.get("supportedKinds").set(index, builder);}
    if (index < 0 || index >= supportedKinds.size()) { supportedKinds.add(builder); } else { supportedKinds.set(index, builder);}
     return (A)this;
  }
  public A addToSupportedKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteGroupKind... items) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").add(builder);this.supportedKinds.add(builder);} return (A)this;
  }
  public A addAllToSupportedKinds(Collection<RouteGroupKind> items) {
    if (this.supportedKinds == null) {this.supportedKinds = new ArrayList<RouteGroupKindBuilder>();}
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").add(builder);this.supportedKinds.add(builder);} return (A)this;
  }
  public A removeFromSupportedKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteGroupKind... items) {
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").remove(builder);if (this.supportedKinds != null) {this.supportedKinds.remove(builder);}} return (A)this;
  }
  public A removeAllFromSupportedKinds(Collection<RouteGroupKind> items) {
    for (RouteGroupKind item : items) {RouteGroupKindBuilder builder = new RouteGroupKindBuilder(item);_visitables.get("supportedKinds").remove(builder);if (this.supportedKinds != null) {this.supportedKinds.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSupportedKinds(Predicate<RouteGroupKindBuilder> predicate) {
    if (supportedKinds == null) return (A) this;
    final Iterator<RouteGroupKindBuilder> each = supportedKinds.iterator();
    final List visitables = _visitables.get("supportedKinds");
    while (each.hasNext()) {
      RouteGroupKindBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSupportedKinds instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<RouteGroupKind> getSupportedKinds() {
    return supportedKinds != null ? build(supportedKinds) : null;
  }
  public List<RouteGroupKind> buildSupportedKinds() {
    return supportedKinds != null ? build(supportedKinds) : null;
  }
  public RouteGroupKind buildSupportedKind(Integer index) {
    return this.supportedKinds.get(index).build();
  }
  public RouteGroupKind buildFirstSupportedKind() {
    return this.supportedKinds.get(0).build();
  }
  public RouteGroupKind buildLastSupportedKind() {
    return this.supportedKinds.get(supportedKinds.size() - 1).build();
  }
  public RouteGroupKind buildMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: supportedKinds) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
    for (RouteGroupKindBuilder item: supportedKinds) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSupportedKinds(List<RouteGroupKind> supportedKinds) {
    if (this.supportedKinds != null) { _visitables.get("supportedKinds").removeAll(this.supportedKinds);}
    if (supportedKinds != null) {this.supportedKinds = new ArrayList(); for (RouteGroupKind item : supportedKinds){this.addToSupportedKinds(item);}} else { this.supportedKinds = null;} return (A) this;
  }
  public A withSupportedKinds(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.RouteGroupKind... supportedKinds) {
    if (this.supportedKinds != null) {this.supportedKinds.clear();}
    if (supportedKinds != null) {for (RouteGroupKind item :supportedKinds){ this.addToSupportedKinds(item);}} return (A) this;
  }
  public Boolean hasSupportedKinds() {
    return supportedKinds != null && !supportedKinds.isEmpty();
  }
  public A addNewSupportedKind(String group,String kind) {
    return (A)addToSupportedKinds(new RouteGroupKind(group, kind));
  }
  public ListenerStatusFluent.SupportedKindsNested<A> addNewSupportedKind() {
    return new ListenerStatusFluentImpl.SupportedKindsNestedImpl();
  }
  public ListenerStatusFluent.SupportedKindsNested<A> addNewSupportedKindLike(RouteGroupKind item) {
    return new ListenerStatusFluentImpl.SupportedKindsNestedImpl(-1, item);
  }
  public ListenerStatusFluent.SupportedKindsNested<A> setNewSupportedKindLike(Integer index,RouteGroupKind item) {
    return new ListenerStatusFluentImpl.SupportedKindsNestedImpl(index, item);
  }
  public ListenerStatusFluent.SupportedKindsNested<A> editSupportedKind(Integer index) {
    if (supportedKinds.size() <= index) throw new RuntimeException("Can't edit supportedKinds. Index exceeds size.");
    return setNewSupportedKindLike(index, buildSupportedKind(index));
  }
  public ListenerStatusFluent.SupportedKindsNested<A> editFirstSupportedKind() {
    if (supportedKinds.size() == 0) throw new RuntimeException("Can't edit first supportedKinds. The list is empty.");
    return setNewSupportedKindLike(0, buildSupportedKind(0));
  }
  public ListenerStatusFluent.SupportedKindsNested<A> editLastSupportedKind() {
    int index = supportedKinds.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last supportedKinds. The list is empty.");
    return setNewSupportedKindLike(index, buildSupportedKind(index));
  }
  public ListenerStatusFluent.SupportedKindsNested<A> editMatchingSupportedKind(Predicate<RouteGroupKindBuilder> predicate) {
    int index = -1;
    for (int i=0;i<supportedKinds.size();i++) { 
    if (predicate.test(supportedKinds.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching supportedKinds. No match found.");
    return setNewSupportedKindLike(index, buildSupportedKind(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ListenerStatusFluentImpl that = (ListenerStatusFluentImpl) o;
    if (attachedRoutes != null ? !attachedRoutes.equals(that.attachedRoutes) :that.attachedRoutes != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (supportedKinds != null ? !supportedKinds.equals(that.supportedKinds) :that.supportedKinds != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(attachedRoutes,  conditions,  name,  supportedKinds,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (attachedRoutes != null) { sb.append("attachedRoutes:"); sb.append(attachedRoutes + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (supportedKinds != null && !supportedKinds.isEmpty()) { sb.append("supportedKinds:"); sb.append(supportedKinds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SupportedKindsNestedImpl<N> extends RouteGroupKindFluentImpl<ListenerStatusFluent.SupportedKindsNested<N>> implements ListenerStatusFluent.SupportedKindsNested<N>,Nested<N>{
    SupportedKindsNestedImpl(Integer index,RouteGroupKind item) {
      this.index = index;
      this.builder = new RouteGroupKindBuilder(this, item);
    }
    SupportedKindsNestedImpl() {
      this.index = -1;
      this.builder = new RouteGroupKindBuilder(this);
    }
    RouteGroupKindBuilder builder;
    Integer index;
    public N and() {
      return (N) ListenerStatusFluentImpl.this.setToSupportedKinds(index,builder.build());
    }
    public N endSupportedKind() {
      return and();
    }
    
  }
  
}