package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPURLRewriteFilterFluentImpl<A extends HTTPURLRewriteFilterFluent<A>> extends BaseFluent<A> implements HTTPURLRewriteFilterFluent<A>{
  public HTTPURLRewriteFilterFluentImpl() {
  }
  public HTTPURLRewriteFilterFluentImpl(HTTPURLRewriteFilter instance) {
    this.withHostname(instance.getHostname()); 
    this.withPath(instance.getPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String hostname;
  private HTTPPathModifierBuilder path;
  private Map<String,Object> additionalProperties;
  public String getHostname() {
    return this.hostname;
  }
  public A withHostname(String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public Boolean hasHostname() {
    return this.hostname != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPath instead.
   * @return The buildable object.
   */
  @Deprecated
  public HTTPPathModifier getPath() {
    return this.path!=null ?this.path.build():null;
  }
  public HTTPPathModifier buildPath() {
    return this.path!=null ?this.path.build():null;
  }
  public A withPath(HTTPPathModifier path) {
    _visitables.get("path").remove(this.path);
    if (path!=null){ this.path= new HTTPPathModifierBuilder(path); _visitables.get("path").add(this.path);} else { this.path = null; _visitables.get("path").remove(this.path); } return (A) this;
  }
  public Boolean hasPath() {
    return this.path != null;
  }
  public A withNewPath(String replaceFullPath,String replacePrefixMatch,String type) {
    return (A)withPath(new HTTPPathModifier(replaceFullPath, replacePrefixMatch, type));
  }
  public HTTPURLRewriteFilterFluent.PathNested<A> withNewPath() {
    return new HTTPURLRewriteFilterFluentImpl.PathNestedImpl();
  }
  public HTTPURLRewriteFilterFluent.PathNested<A> withNewPathLike(HTTPPathModifier item) {
    return new HTTPURLRewriteFilterFluentImpl.PathNestedImpl(item);
  }
  public HTTPURLRewriteFilterFluent.PathNested<A> editPath() {
    return withNewPathLike(getPath());
  }
  public HTTPURLRewriteFilterFluent.PathNested<A> editOrNewPath() {
    return withNewPathLike(getPath() != null ? getPath(): new HTTPPathModifierBuilder().build());
  }
  public HTTPURLRewriteFilterFluent.PathNested<A> editOrNewPathLike(HTTPPathModifier item) {
    return withNewPathLike(getPath() != null ? getPath(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPURLRewriteFilterFluentImpl that = (HTTPURLRewriteFilterFluentImpl) o;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (path != null ? !path.equals(that.path) :that.path != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hostname,  path,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PathNestedImpl<N> extends HTTPPathModifierFluentImpl<HTTPURLRewriteFilterFluent.PathNested<N>> implements HTTPURLRewriteFilterFluent.PathNested<N>,Nested<N>{
    PathNestedImpl(HTTPPathModifier item) {
      this.builder = new HTTPPathModifierBuilder(this, item);
    }
    PathNestedImpl() {
      this.builder = new HTTPPathModifierBuilder(this);
    }
    HTTPPathModifierBuilder builder;
    public N and() {
      return (N) HTTPURLRewriteFilterFluentImpl.this.withPath(builder.build());
    }
    public N endPath() {
      return and();
    }
    
  }
  
}