package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayClassBuilder extends GatewayClassFluentImpl<GatewayClassBuilder> implements VisitableBuilder<GatewayClass,GatewayClassBuilder>{
  public GatewayClassBuilder() {
    this(false);
  }
  public GatewayClassBuilder(Boolean validationEnabled) {
    this(new GatewayClass(), validationEnabled);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayClass(), validationEnabled);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,GatewayClass instance) {
    this(fluent, instance, false);
  }
  public GatewayClassBuilder(GatewayClassFluent<?> fluent,GatewayClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GatewayClassBuilder(GatewayClass instance) {
    this(instance,false);
  }
  public GatewayClassBuilder(GatewayClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GatewayClassFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayClass build() {
    GatewayClass buildable = new GatewayClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}