package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class GRPCBackendRefFluent<A extends GRPCBackendRefFluent<A>> extends BaseFluent<A>{
  public GRPCBackendRefFluent() {
  }
  
  public GRPCBackendRefFluent(GRPCBackendRef instance) {
    this.copyInstance(instance);
  }
  private ArrayList<GRPCRouteFilterBuilder> filters = new ArrayList<GRPCRouteFilterBuilder>();
  private String group;
  private String kind;
  private String name;
  private String namespace;
  private Integer port;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(GRPCBackendRef instance) {
    instance = (instance != null ? instance : new GRPCBackendRef());
    if (instance != null) {
          this.withFilters(instance.getFilters());
          this.withGroup(instance.getGroup());
          this.withKind(instance.getKind());
          this.withName(instance.getName());
          this.withNamespace(instance.getNamespace());
          this.withPort(instance.getPort());
          this.withWeight(instance.getWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToFilters(int index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").add(index, builder); filters.add(index, builder);}
    return (A)this;
  }
  
  public A setToFilters(int index,GRPCRouteFilter item) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);
    if (index < 0 || index >= filters.size()) { _visitables.get("filters").add(builder); filters.add(builder); } else { _visitables.get("filters").set(index, builder); filters.set(index, builder);}
    return (A)this;
  }
  
  public A addToFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A addAllToFilters(Collection<GRPCRouteFilter> items) {
    if (this.filters == null) {this.filters = new ArrayList<GRPCRouteFilterBuilder>();}
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").add(builder);this.filters.add(builder);} return (A)this;
  }
  
  public A removeFromFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... items) {
    if (this.filters == null) return (A)this;
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFilters(Collection<GRPCRouteFilter> items) {
    if (this.filters == null) return (A)this;
    for (GRPCRouteFilter item : items) {GRPCRouteFilterBuilder builder = new GRPCRouteFilterBuilder(item);_visitables.get("filters").remove(builder); this.filters.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFilters(Predicate<GRPCRouteFilterBuilder> predicate) {
    if (filters == null) return (A) this;
    final Iterator<GRPCRouteFilterBuilder> each = filters.iterator();
    final List visitables = _visitables.get("filters");
    while (each.hasNext()) {
      GRPCRouteFilterBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<GRPCRouteFilter> buildFilters() {
    return this.filters != null ? build(filters) : null;
  }
  
  public GRPCRouteFilter buildFilter(int index) {
    return this.filters.get(index).build();
  }
  
  public GRPCRouteFilter buildFirstFilter() {
    return this.filters.get(0).build();
  }
  
  public GRPCRouteFilter buildLastFilter() {
    return this.filters.get(filters.size() - 1).build();
  }
  
  public GRPCRouteFilter buildMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
      for (GRPCRouteFilterBuilder item : filters) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
      for (GRPCRouteFilterBuilder item : filters) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFilters(List<GRPCRouteFilter> filters) {
    if (this.filters != null) {
      this._visitables.get("filters").clear();
    }
    if (filters != null) {
        this.filters = new ArrayList();
        for (GRPCRouteFilter item : filters) {
          this.addToFilters(item);
        }
    } else {
      this.filters = null;
    }
    return (A) this;
  }
  
  public A withFilters(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GRPCRouteFilter... filters) {
    if (this.filters != null) {
        this.filters.clear();
        _visitables.remove("filters");
    }
    if (filters != null) {
      for (GRPCRouteFilter item : filters) {
        this.addToFilters(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFilters() {
    return this.filters != null && !this.filters.isEmpty();
  }
  
  public FiltersNested<A> addNewFilter() {
    return new FiltersNested(-1, null);
  }
  
  public FiltersNested<A> addNewFilterLike(GRPCRouteFilter item) {
    return new FiltersNested(-1, item);
  }
  
  public FiltersNested<A> setNewFilterLike(int index,GRPCRouteFilter item) {
    return new FiltersNested(index, item);
  }
  
  public FiltersNested<A> editFilter(int index) {
    if (filters.size() <= index) throw new RuntimeException("Can't edit filters. Index exceeds size.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editFirstFilter() {
    if (filters.size() == 0) throw new RuntimeException("Can't edit first filters. The list is empty.");
    return setNewFilterLike(0, buildFilter(0));
  }
  
  public FiltersNested<A> editLastFilter() {
    int index = filters.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last filters. The list is empty.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public FiltersNested<A> editMatchingFilter(Predicate<GRPCRouteFilterBuilder> predicate) {
    int index = -1;
    for (int i=0;i<filters.size();i++) { 
    if (predicate.test(filters.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching filters. No match found.");
    return setNewFilterLike(index, buildFilter(index));
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public Integer getWeight() {
    return this.weight;
  }
  
  public A withWeight(Integer weight) {
    this.weight = weight;
    return (A) this;
  }
  
  public boolean hasWeight() {
    return this.weight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GRPCBackendRefFluent that = (GRPCBackendRefFluent) o;
    if (!java.util.Objects.equals(filters, that.filters)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(weight, that.weight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(filters,  group,  kind,  name,  namespace,  port,  weight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (filters != null && !filters.isEmpty()) { sb.append("filters:"); sb.append(filters + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FiltersNested<N> extends GRPCRouteFilterFluent<FiltersNested<N>> implements Nested<N>{
    FiltersNested(int index,GRPCRouteFilter item) {
      this.index = index;
      this.builder = new GRPCRouteFilterBuilder(this, item);
    }
    GRPCRouteFilterBuilder builder;
    int index;
    
    public N and() {
      return (N) GRPCBackendRefFluent.this.setToFilters(index,builder.build());
    }
    
    public N endFilter() {
      return and();
    }
    
  
  }

}