package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BackendTLSPolicySpecFluent<A extends BackendTLSPolicySpecFluent<A>> extends BaseFluent<A>{
  public BackendTLSPolicySpecFluent() {
  }
  
  public BackendTLSPolicySpecFluent(BackendTLSPolicySpec instance) {
    this.copyInstance(instance);
  }
  private PolicyTargetReferenceWithSectionNameBuilder targetRef;
  private BackendTLSPolicyConfigBuilder tls;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BackendTLSPolicySpec instance) {
    instance = (instance != null ? instance : new BackendTLSPolicySpec());
    if (instance != null) {
          this.withTargetRef(instance.getTargetRef());
          this.withTls(instance.getTls());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public PolicyTargetReferenceWithSectionName buildTargetRef() {
    return this.targetRef != null ? this.targetRef.build() : null;
  }
  
  public A withTargetRef(PolicyTargetReferenceWithSectionName targetRef) {
    this._visitables.remove("targetRef");
    if (targetRef != null) {
        this.targetRef = new PolicyTargetReferenceWithSectionNameBuilder(targetRef);
        this._visitables.get("targetRef").add(this.targetRef);
    } else {
        this.targetRef = null;
        this._visitables.get("targetRef").remove(this.targetRef);
    }
    return (A) this;
  }
  
  public boolean hasTargetRef() {
    return this.targetRef != null;
  }
  
  public A withNewTargetRef(String group,String kind,String name,String namespace,String sectionName) {
    return (A)withTargetRef(new PolicyTargetReferenceWithSectionName(group, kind, name, namespace, sectionName));
  }
  
  public TargetRefNested<A> withNewTargetRef() {
    return new TargetRefNested(null);
  }
  
  public TargetRefNested<A> withNewTargetRefLike(PolicyTargetReferenceWithSectionName item) {
    return new TargetRefNested(item);
  }
  
  public TargetRefNested<A> editTargetRef() {
    return withNewTargetRefLike(java.util.Optional.ofNullable(buildTargetRef()).orElse(null));
  }
  
  public TargetRefNested<A> editOrNewTargetRef() {
    return withNewTargetRefLike(java.util.Optional.ofNullable(buildTargetRef()).orElse(new PolicyTargetReferenceWithSectionNameBuilder().build()));
  }
  
  public TargetRefNested<A> editOrNewTargetRefLike(PolicyTargetReferenceWithSectionName item) {
    return withNewTargetRefLike(java.util.Optional.ofNullable(buildTargetRef()).orElse(item));
  }
  
  public BackendTLSPolicyConfig buildTls() {
    return this.tls != null ? this.tls.build() : null;
  }
  
  public A withTls(BackendTLSPolicyConfig tls) {
    this._visitables.remove("tls");
    if (tls != null) {
        this.tls = new BackendTLSPolicyConfigBuilder(tls);
        this._visitables.get("tls").add(this.tls);
    } else {
        this.tls = null;
        this._visitables.get("tls").remove(this.tls);
    }
    return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(BackendTLSPolicyConfig item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new BackendTLSPolicyConfigBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(BackendTLSPolicyConfig item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackendTLSPolicySpecFluent that = (BackendTLSPolicySpecFluent) o;
    if (!java.util.Objects.equals(targetRef, that.targetRef)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(targetRef,  tls,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (targetRef != null) { sb.append("targetRef:"); sb.append(targetRef + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TargetRefNested<N> extends PolicyTargetReferenceWithSectionNameFluent<TargetRefNested<N>> implements Nested<N>{
    TargetRefNested(PolicyTargetReferenceWithSectionName item) {
      this.builder = new PolicyTargetReferenceWithSectionNameBuilder(this, item);
    }
    PolicyTargetReferenceWithSectionNameBuilder builder;
    
    public N and() {
      return (N) BackendTLSPolicySpecFluent.this.withTargetRef(builder.build());
    }
    
    public N endTargetRef() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends BackendTLSPolicyConfigFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(BackendTLSPolicyConfig item) {
      this.builder = new BackendTLSPolicyConfigBuilder(this, item);
    }
    BackendTLSPolicyConfigBuilder builder;
    
    public N and() {
      return (N) BackendTLSPolicySpecFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}