package io.fabric8.kubernetes.api.model.gatewayapi.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HTTPRouteRuleBuilder extends HTTPRouteRuleFluent<HTTPRouteRuleBuilder> implements VisitableBuilder<HTTPRouteRule,HTTPRouteRuleBuilder>{
  public HTTPRouteRuleBuilder() {
    this(new HTTPRouteRule());
  }
  
  public HTTPRouteRuleBuilder(HTTPRouteRuleFluent<?> fluent) {
    this(fluent, new HTTPRouteRule());
  }
  
  public HTTPRouteRuleBuilder(HTTPRouteRuleFluent<?> fluent,HTTPRouteRule instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HTTPRouteRuleBuilder(HTTPRouteRule instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HTTPRouteRuleFluent<?> fluent;
  
  public HTTPRouteRule build() {
    HTTPRouteRule buildable = new HTTPRouteRule(fluent.buildBackendRefs(),fluent.buildFilters(),fluent.buildMatches(),fluent.buildTimeouts());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}