package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReferenceBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;
import io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReferenceFluent;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class BackendTLSPolicyConfigFluent<A extends BackendTLSPolicyConfigFluent<A>> extends BaseFluent<A>{
  public BackendTLSPolicyConfigFluent() {
  }
  
  public BackendTLSPolicyConfigFluent(BackendTLSPolicyConfig instance) {
    this.copyInstance(instance);
  }
  private ArrayList<LocalObjectReferenceBuilder> caCertRefs = new ArrayList<LocalObjectReferenceBuilder>();
  private String hostname;
  private String wellKnownCACerts;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(BackendTLSPolicyConfig instance) {
    instance = (instance != null ? instance : new BackendTLSPolicyConfig());
    if (instance != null) {
          this.withCaCertRefs(instance.getCaCertRefs());
          this.withHostname(instance.getHostname());
          this.withWellKnownCACerts(instance.getWellKnownCACerts());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToCaCertRefs(int index,LocalObjectReference item) {
    if (this.caCertRefs == null) {this.caCertRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= caCertRefs.size()) { _visitables.get("caCertRefs").add(builder); caCertRefs.add(builder); } else { _visitables.get("caCertRefs").add(index, builder); caCertRefs.add(index, builder);}
    return (A)this;
  }
  
  public A setToCaCertRefs(int index,LocalObjectReference item) {
    if (this.caCertRefs == null) {this.caCertRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);
    if (index < 0 || index >= caCertRefs.size()) { _visitables.get("caCertRefs").add(builder); caCertRefs.add(builder); } else { _visitables.get("caCertRefs").set(index, builder); caCertRefs.set(index, builder);}
    return (A)this;
  }
  
  public A addToCaCertRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReference... items) {
    if (this.caCertRefs == null) {this.caCertRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("caCertRefs").add(builder);this.caCertRefs.add(builder);} return (A)this;
  }
  
  public A addAllToV1CaCertRefs(Collection<LocalObjectReference> items) {
    if (this.caCertRefs == null) {this.caCertRefs = new ArrayList<LocalObjectReferenceBuilder>();}
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("caCertRefs").add(builder);this.caCertRefs.add(builder);} return (A)this;
  }
  
  public A removeFromCaCertRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReference... items) {
    if (this.caCertRefs == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("caCertRefs").remove(builder); this.caCertRefs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromV1CaCertRefs(Collection<LocalObjectReference> items) {
    if (this.caCertRefs == null) return (A)this;
    for (LocalObjectReference item : items) {LocalObjectReferenceBuilder builder = new LocalObjectReferenceBuilder(item);_visitables.get("caCertRefs").remove(builder); this.caCertRefs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromV1CaCertRefs(Predicate<LocalObjectReferenceBuilder> predicate) {
    if (caCertRefs == null) return (A) this;
    final Iterator<LocalObjectReferenceBuilder> each = caCertRefs.iterator();
    final List visitables = _visitables.get("caCertRefs");
    while (each.hasNext()) {
      LocalObjectReferenceBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<LocalObjectReference> buildCaCertRefs() {
    return this.caCertRefs != null ? build(caCertRefs) : null;
  }
  
  public LocalObjectReference buildCaCertRef(int index) {
    return this.caCertRefs.get(index).build();
  }
  
  public LocalObjectReference buildFirstCaCertRef() {
    return this.caCertRefs.get(0).build();
  }
  
  public LocalObjectReference buildLastCaCertRef() {
    return this.caCertRefs.get(caCertRefs.size() - 1).build();
  }
  
  public LocalObjectReference buildMatchingCaCertRef(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : caCertRefs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCaCertRef(Predicate<LocalObjectReferenceBuilder> predicate) {
      for (LocalObjectReferenceBuilder item : caCertRefs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withCaCertRefs(List<LocalObjectReference> caCertRefs) {
    if (this.caCertRefs != null) {
      this._visitables.get("caCertRefs").clear();
    }
    if (caCertRefs != null) {
        this.caCertRefs = new ArrayList();
        for (LocalObjectReference item : caCertRefs) {
          this.addToCaCertRefs(item);
        }
    } else {
      this.caCertRefs = null;
    }
    return (A) this;
  }
  
  public A withCaCertRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1.LocalObjectReference... caCertRefs) {
    if (this.caCertRefs != null) {
        this.caCertRefs.clear();
        _visitables.remove("caCertRefs");
    }
    if (caCertRefs != null) {
      for (LocalObjectReference item : caCertRefs) {
        this.addToCaCertRefs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasCaCertRefs() {
    return this.caCertRefs != null && !this.caCertRefs.isEmpty();
  }
  
  public A addNewCaCertRef(String group,String kind,String name) {
    return (A)addToCaCertRefs(new LocalObjectReference(group, kind, name));
  }
  
  public CaCertRefsNested<A> addNewCaCertRef() {
    return new CaCertRefsNested(-1, null);
  }
  
  public CaCertRefsNested<A> addNewCaCertRefLike(LocalObjectReference item) {
    return new CaCertRefsNested(-1, item);
  }
  
  public CaCertRefsNested<A> setNewCaCertRefLike(int index,LocalObjectReference item) {
    return new CaCertRefsNested(index, item);
  }
  
  public CaCertRefsNested<A> editCaCertRef(int index) {
    if (caCertRefs.size() <= index) throw new RuntimeException("Can't edit caCertRefs. Index exceeds size.");
    return setNewCaCertRefLike(index, buildCaCertRef(index));
  }
  
  public CaCertRefsNested<A> editFirstCaCertRef() {
    if (caCertRefs.size() == 0) throw new RuntimeException("Can't edit first caCertRefs. The list is empty.");
    return setNewCaCertRefLike(0, buildCaCertRef(0));
  }
  
  public CaCertRefsNested<A> editLastCaCertRef() {
    int index = caCertRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last caCertRefs. The list is empty.");
    return setNewCaCertRefLike(index, buildCaCertRef(index));
  }
  
  public CaCertRefsNested<A> editMatchingCaCertRef(Predicate<LocalObjectReferenceBuilder> predicate) {
    int index = -1;
    for (int i=0;i<caCertRefs.size();i++) { 
    if (predicate.test(caCertRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching caCertRefs. No match found.");
    return setNewCaCertRefLike(index, buildCaCertRef(index));
  }
  
  public String getHostname() {
    return this.hostname;
  }
  
  public A withHostname(String hostname) {
    this.hostname = hostname;
    return (A) this;
  }
  
  public boolean hasHostname() {
    return this.hostname != null;
  }
  
  public String getWellKnownCACerts() {
    return this.wellKnownCACerts;
  }
  
  public A withWellKnownCACerts(String wellKnownCACerts) {
    this.wellKnownCACerts = wellKnownCACerts;
    return (A) this;
  }
  
  public boolean hasWellKnownCACerts() {
    return this.wellKnownCACerts != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    BackendTLSPolicyConfigFluent that = (BackendTLSPolicyConfigFluent) o;
    if (!java.util.Objects.equals(caCertRefs, that.caCertRefs)) return false;
    if (!java.util.Objects.equals(hostname, that.hostname)) return false;
    if (!java.util.Objects.equals(wellKnownCACerts, that.wellKnownCACerts)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(caCertRefs,  hostname,  wellKnownCACerts,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caCertRefs != null && !caCertRefs.isEmpty()) { sb.append("caCertRefs:"); sb.append(caCertRefs + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (wellKnownCACerts != null) { sb.append("wellKnownCACerts:"); sb.append(wellKnownCACerts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class CaCertRefsNested<N> extends LocalObjectReferenceFluent<CaCertRefsNested<N>> implements Nested<N>{
    CaCertRefsNested(int index,LocalObjectReference item) {
      this.index = index;
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    int index;
    
    public N and() {
      return (N) BackendTLSPolicyConfigFluent.this.setToCaCertRefs(index,builder.build());
    }
    
    public N endV1CaCertRef() {
      return and();
    }
    
  
  }

}