package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayClassListBuilder extends GatewayClassListFluentImpl<GatewayClassListBuilder> implements VisitableBuilder<GatewayClassList,GatewayClassListBuilder>{
  public GatewayClassListBuilder() {
    this(false);
  }
  public GatewayClassListBuilder(Boolean validationEnabled) {
    this(new GatewayClassList(), validationEnabled);
  }
  public GatewayClassListBuilder(GatewayClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayClassListBuilder(GatewayClassListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayClassList(), validationEnabled);
  }
  public GatewayClassListBuilder(GatewayClassListFluent<?> fluent,GatewayClassList instance) {
    this(fluent, instance, false);
  }
  public GatewayClassListBuilder(GatewayClassListFluent<?> fluent,GatewayClassList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GatewayClassListBuilder(GatewayClassList instance) {
    this(instance,false);
  }
  public GatewayClassListBuilder(GatewayClassList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GatewayClassListFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayClassList build() {
    GatewayClassList buildable = new GatewayClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}