package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayClassStatusBuilder extends GatewayClassStatusFluentImpl<GatewayClassStatusBuilder> implements VisitableBuilder<GatewayClassStatus,GatewayClassStatusBuilder>{
  public GatewayClassStatusBuilder() {
    this(false);
  }
  public GatewayClassStatusBuilder(Boolean validationEnabled) {
    this(new GatewayClassStatus(), validationEnabled);
  }
  public GatewayClassStatusBuilder(GatewayClassStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayClassStatusBuilder(GatewayClassStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GatewayClassStatus(), validationEnabled);
  }
  public GatewayClassStatusBuilder(GatewayClassStatusFluent<?> fluent,GatewayClassStatus instance) {
    this(fluent, instance, false);
  }
  public GatewayClassStatusBuilder(GatewayClassStatusFluent<?> fluent,GatewayClassStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GatewayClassStatusBuilder(GatewayClassStatus instance) {
    this(instance,false);
  }
  public GatewayClassStatusBuilder(GatewayClassStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  GatewayClassStatusFluent<?> fluent;
  Boolean validationEnabled;
  public GatewayClassStatus build() {
    GatewayClassStatus buildable = new GatewayClassStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}