package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class UDPRouteRuleFluentImpl<A extends UDPRouteRuleFluent<A>> extends BaseFluent<A> implements UDPRouteRuleFluent<A>{
  public UDPRouteRuleFluentImpl() {
  }
  public UDPRouteRuleFluentImpl(UDPRouteRule instance) {
    this.withBackendRefs(instance.getBackendRefs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<BackendRefBuilder> backendRefs = new ArrayList<BackendRefBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToBackendRefs(Integer index,BackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<BackendRefBuilder>();}
    BackendRefBuilder builder = new BackendRefBuilder(item);_visitables.get("backendRefs").add(index >= 0 ? index : _visitables.get("backendRefs").size(), builder);this.backendRefs.add(index >= 0 ? index : backendRefs.size(), builder); return (A)this;
  }
  public A setToBackendRefs(Integer index,BackendRef item) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<BackendRefBuilder>();}
    BackendRefBuilder builder = new BackendRefBuilder(item);
    if (index < 0 || index >= _visitables.get("backendRefs").size()) { _visitables.get("backendRefs").add(builder); } else { _visitables.get("backendRefs").set(index, builder);}
    if (index < 0 || index >= backendRefs.size()) { backendRefs.add(builder); } else { backendRefs.set(index, builder);}
     return (A)this;
  }
  public A addToBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.BackendRef... items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<BackendRefBuilder>();}
    for (BackendRef item : items) {BackendRefBuilder builder = new BackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A addAllToBackendRefs(Collection<BackendRef> items) {
    if (this.backendRefs == null) {this.backendRefs = new ArrayList<BackendRefBuilder>();}
    for (BackendRef item : items) {BackendRefBuilder builder = new BackendRefBuilder(item);_visitables.get("backendRefs").add(builder);this.backendRefs.add(builder);} return (A)this;
  }
  public A removeFromBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.BackendRef... items) {
    for (BackendRef item : items) {BackendRefBuilder builder = new BackendRefBuilder(item);_visitables.get("backendRefs").remove(builder);if (this.backendRefs != null) {this.backendRefs.remove(builder);}} return (A)this;
  }
  public A removeAllFromBackendRefs(Collection<BackendRef> items) {
    for (BackendRef item : items) {BackendRefBuilder builder = new BackendRefBuilder(item);_visitables.get("backendRefs").remove(builder);if (this.backendRefs != null) {this.backendRefs.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromBackendRefs(Predicate<BackendRefBuilder> predicate) {
    if (backendRefs == null) return (A) this;
    final Iterator<BackendRefBuilder> each = backendRefs.iterator();
    final List visitables = _visitables.get("backendRefs");
    while (each.hasNext()) {
      BackendRefBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildBackendRefs instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<BackendRef> getBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public List<BackendRef> buildBackendRefs() {
    return backendRefs != null ? build(backendRefs) : null;
  }
  public BackendRef buildBackendRef(Integer index) {
    return this.backendRefs.get(index).build();
  }
  public BackendRef buildFirstBackendRef() {
    return this.backendRefs.get(0).build();
  }
  public BackendRef buildLastBackendRef() {
    return this.backendRefs.get(backendRefs.size() - 1).build();
  }
  public BackendRef buildMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
    for (BackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
    for (BackendRefBuilder item: backendRefs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBackendRefs(List<BackendRef> backendRefs) {
    if (this.backendRefs != null) { _visitables.get("backendRefs").removeAll(this.backendRefs);}
    if (backendRefs != null) {this.backendRefs = new ArrayList(); for (BackendRef item : backendRefs){this.addToBackendRefs(item);}} else { this.backendRefs = null;} return (A) this;
  }
  public A withBackendRefs(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.BackendRef... backendRefs) {
    if (this.backendRefs != null) {this.backendRefs.clear();}
    if (backendRefs != null) {for (BackendRef item :backendRefs){ this.addToBackendRefs(item);}} return (A) this;
  }
  public Boolean hasBackendRefs() {
    return backendRefs != null && !backendRefs.isEmpty();
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> addNewBackendRef() {
    return new UDPRouteRuleFluentImpl.BackendRefsNestedImpl();
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> addNewBackendRefLike(BackendRef item) {
    return new UDPRouteRuleFluentImpl.BackendRefsNestedImpl(-1, item);
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> setNewBackendRefLike(Integer index,BackendRef item) {
    return new UDPRouteRuleFluentImpl.BackendRefsNestedImpl(index, item);
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> editBackendRef(Integer index) {
    if (backendRefs.size() <= index) throw new RuntimeException("Can't edit backendRefs. Index exceeds size.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> editFirstBackendRef() {
    if (backendRefs.size() == 0) throw new RuntimeException("Can't edit first backendRefs. The list is empty.");
    return setNewBackendRefLike(0, buildBackendRef(0));
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> editLastBackendRef() {
    int index = backendRefs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last backendRefs. The list is empty.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public UDPRouteRuleFluent.BackendRefsNested<A> editMatchingBackendRef(Predicate<BackendRefBuilder> predicate) {
    int index = -1;
    for (int i=0;i<backendRefs.size();i++) { 
    if (predicate.test(backendRefs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching backendRefs. No match found.");
    return setNewBackendRefLike(index, buildBackendRef(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    UDPRouteRuleFluentImpl that = (UDPRouteRuleFluentImpl) o;
    if (backendRefs != null ? !backendRefs.equals(that.backendRefs) :that.backendRefs != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backendRefs,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backendRefs != null && !backendRefs.isEmpty()) { sb.append("backendRefs:"); sb.append(backendRefs + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class BackendRefsNestedImpl<N> extends BackendRefFluentImpl<UDPRouteRuleFluent.BackendRefsNested<N>> implements UDPRouteRuleFluent.BackendRefsNested<N>,Nested<N>{
    BackendRefsNestedImpl(Integer index,BackendRef item) {
      this.index = index;
      this.builder = new BackendRefBuilder(this, item);
    }
    BackendRefsNestedImpl() {
      this.index = -1;
      this.builder = new BackendRefBuilder(this);
    }
    BackendRefBuilder builder;
    Integer index;
    public N and() {
      return (N) UDPRouteRuleFluentImpl.this.setToBackendRefs(index,builder.build());
    }
    public N endBackendRef() {
      return and();
    }
    
  }
  
}