package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteFilterBuilder extends HTTPRouteFilterFluentImpl<HTTPRouteFilterBuilder> implements VisitableBuilder<HTTPRouteFilter,HTTPRouteFilterBuilder>{
  public HTTPRouteFilterBuilder() {
    this(false);
  }
  public HTTPRouteFilterBuilder(Boolean validationEnabled) {
    this(new HTTPRouteFilter(), validationEnabled);
  }
  public HTTPRouteFilterBuilder(HTTPRouteFilterFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteFilterBuilder(HTTPRouteFilterFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRouteFilter(), validationEnabled);
  }
  public HTTPRouteFilterBuilder(HTTPRouteFilterFluent<?> fluent,HTTPRouteFilter instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteFilterBuilder(HTTPRouteFilterFluent<?> fluent,HTTPRouteFilter instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExtensionRef(instance.getExtensionRef()); 
    fluent.withRequestHeaderModifier(instance.getRequestHeaderModifier()); 
    fluent.withRequestMirror(instance.getRequestMirror()); 
    fluent.withRequestRedirect(instance.getRequestRedirect()); 
    fluent.withType(instance.getType()); 
    fluent.withUrlRewrite(instance.getUrlRewrite()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteFilterBuilder(HTTPRouteFilter instance) {
    this(instance,false);
  }
  public HTTPRouteFilterBuilder(HTTPRouteFilter instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExtensionRef(instance.getExtensionRef()); 
    this.withRequestHeaderModifier(instance.getRequestHeaderModifier()); 
    this.withRequestMirror(instance.getRequestMirror()); 
    this.withRequestRedirect(instance.getRequestRedirect()); 
    this.withType(instance.getType()); 
    this.withUrlRewrite(instance.getUrlRewrite()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteFilterFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRouteFilter build() {
    HTTPRouteFilter buildable = new HTTPRouteFilter(fluent.getExtensionRef(),fluent.getRequestHeaderModifier(),fluent.getRequestMirror(),fluent.getRequestRedirect(),fluent.getType(),fluent.getUrlRewrite());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}