package io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GatewaySpecFluentImpl<A extends GatewaySpecFluent<A>> extends BaseFluent<A> implements GatewaySpecFluent<A>{
  public GatewaySpecFluentImpl() {
  }
  public GatewaySpecFluentImpl(GatewaySpec instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withGatewayClassName(instance.getGatewayClassName()); 
    this.withListeners(instance.getListeners()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<GatewayAddressBuilder> addresses = new ArrayList<GatewayAddressBuilder>();
  private String gatewayClassName;
  private ArrayList<ListenerBuilder> listeners = new ArrayList<ListenerBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToAddresses(Integer index,GatewayAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<GatewayAddressBuilder>();}
    GatewayAddressBuilder builder = new GatewayAddressBuilder(item);_visitables.get("addresses").add(index >= 0 ? index : _visitables.get("addresses").size(), builder);this.addresses.add(index >= 0 ? index : addresses.size(), builder); return (A)this;
  }
  public A setToAddresses(Integer index,GatewayAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<GatewayAddressBuilder>();}
    GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
    if (index < 0 || index >= _visitables.get("addresses").size()) { _visitables.get("addresses").add(builder); } else { _visitables.get("addresses").set(index, builder);}
    if (index < 0 || index >= addresses.size()) { addresses.add(builder); } else { addresses.set(index, builder);}
     return (A)this;
  }
  public A addToAddresses(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GatewayAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<GatewayAddressBuilder>();}
    for (GatewayAddress item : items) {GatewayAddressBuilder builder = new GatewayAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A addAllToAddresses(Collection<GatewayAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<GatewayAddressBuilder>();}
    for (GatewayAddress item : items) {GatewayAddressBuilder builder = new GatewayAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GatewayAddress... items) {
    for (GatewayAddress item : items) {GatewayAddressBuilder builder = new GatewayAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeAllFromAddresses(Collection<GatewayAddress> items) {
    for (GatewayAddress item : items) {GatewayAddressBuilder builder = new GatewayAddressBuilder(item);_visitables.get("addresses").remove(builder);if (this.addresses != null) {this.addresses.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAddresses(Predicate<GatewayAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<GatewayAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      GatewayAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAddresses instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<GatewayAddress> getAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public List<GatewayAddress> buildAddresses() {
    return addresses != null ? build(addresses) : null;
  }
  public GatewayAddress buildAddress(Integer index) {
    return this.addresses.get(index).build();
  }
  public GatewayAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  public GatewayAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  public GatewayAddress buildMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
    for (GatewayAddressBuilder item: addresses) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
    for (GatewayAddressBuilder item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<GatewayAddress> addresses) {
    if (this.addresses != null) { _visitables.get("addresses").removeAll(this.addresses);}
    if (addresses != null) {this.addresses = new ArrayList(); for (GatewayAddress item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.GatewayAddress... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (GatewayAddress item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addNewAddress(String type,String value) {
    return (A)addToAddresses(new GatewayAddress(type, value));
  }
  public GatewaySpecFluent.AddressesNested<A> addNewAddress() {
    return new GatewaySpecFluentImpl.AddressesNestedImpl();
  }
  public GatewaySpecFluent.AddressesNested<A> addNewAddressLike(GatewayAddress item) {
    return new GatewaySpecFluentImpl.AddressesNestedImpl(-1, item);
  }
  public GatewaySpecFluent.AddressesNested<A> setNewAddressLike(Integer index,GatewayAddress item) {
    return new GatewaySpecFluentImpl.AddressesNestedImpl(index, item);
  }
  public GatewaySpecFluent.AddressesNested<A> editAddress(Integer index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public GatewaySpecFluent.AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  public GatewaySpecFluent.AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public GatewaySpecFluent.AddressesNested<A> editMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  public String getGatewayClassName() {
    return this.gatewayClassName;
  }
  public A withGatewayClassName(String gatewayClassName) {
    this.gatewayClassName=gatewayClassName; return (A) this;
  }
  public Boolean hasGatewayClassName() {
    return this.gatewayClassName != null;
  }
  public A addToListeners(Integer index,Listener item) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerBuilder>();}
    ListenerBuilder builder = new ListenerBuilder(item);_visitables.get("listeners").add(index >= 0 ? index : _visitables.get("listeners").size(), builder);this.listeners.add(index >= 0 ? index : listeners.size(), builder); return (A)this;
  }
  public A setToListeners(Integer index,Listener item) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerBuilder>();}
    ListenerBuilder builder = new ListenerBuilder(item);
    if (index < 0 || index >= _visitables.get("listeners").size()) { _visitables.get("listeners").add(builder); } else { _visitables.get("listeners").set(index, builder);}
    if (index < 0 || index >= listeners.size()) { listeners.add(builder); } else { listeners.set(index, builder);}
     return (A)this;
  }
  public A addToListeners(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.Listener... items) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerBuilder>();}
    for (Listener item : items) {ListenerBuilder builder = new ListenerBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
  }
  public A addAllToListeners(Collection<Listener> items) {
    if (this.listeners == null) {this.listeners = new ArrayList<ListenerBuilder>();}
    for (Listener item : items) {ListenerBuilder builder = new ListenerBuilder(item);_visitables.get("listeners").add(builder);this.listeners.add(builder);} return (A)this;
  }
  public A removeFromListeners(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.Listener... items) {
    for (Listener item : items) {ListenerBuilder builder = new ListenerBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
  }
  public A removeAllFromListeners(Collection<Listener> items) {
    for (Listener item : items) {ListenerBuilder builder = new ListenerBuilder(item);_visitables.get("listeners").remove(builder);if (this.listeners != null) {this.listeners.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromListeners(Predicate<ListenerBuilder> predicate) {
    if (listeners == null) return (A) this;
    final Iterator<ListenerBuilder> each = listeners.iterator();
    final List visitables = _visitables.get("listeners");
    while (each.hasNext()) {
      ListenerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildListeners instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Listener> getListeners() {
    return listeners != null ? build(listeners) : null;
  }
  public List<Listener> buildListeners() {
    return listeners != null ? build(listeners) : null;
  }
  public Listener buildListener(Integer index) {
    return this.listeners.get(index).build();
  }
  public Listener buildFirstListener() {
    return this.listeners.get(0).build();
  }
  public Listener buildLastListener() {
    return this.listeners.get(listeners.size() - 1).build();
  }
  public Listener buildMatchingListener(Predicate<ListenerBuilder> predicate) {
    for (ListenerBuilder item: listeners) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingListener(Predicate<ListenerBuilder> predicate) {
    for (ListenerBuilder item: listeners) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withListeners(List<Listener> listeners) {
    if (this.listeners != null) { _visitables.get("listeners").removeAll(this.listeners);}
    if (listeners != null) {this.listeners = new ArrayList(); for (Listener item : listeners){this.addToListeners(item);}} else { this.listeners = null;} return (A) this;
  }
  public A withListeners(io.fabric8.kubernetes.api.model.gatewayapi.v1alpha2.Listener... listeners) {
    if (this.listeners != null) {this.listeners.clear();}
    if (listeners != null) {for (Listener item :listeners){ this.addToListeners(item);}} return (A) this;
  }
  public Boolean hasListeners() {
    return listeners != null && !listeners.isEmpty();
  }
  public GatewaySpecFluent.ListenersNested<A> addNewListener() {
    return new GatewaySpecFluentImpl.ListenersNestedImpl();
  }
  public GatewaySpecFluent.ListenersNested<A> addNewListenerLike(Listener item) {
    return new GatewaySpecFluentImpl.ListenersNestedImpl(-1, item);
  }
  public GatewaySpecFluent.ListenersNested<A> setNewListenerLike(Integer index,Listener item) {
    return new GatewaySpecFluentImpl.ListenersNestedImpl(index, item);
  }
  public GatewaySpecFluent.ListenersNested<A> editListener(Integer index) {
    if (listeners.size() <= index) throw new RuntimeException("Can't edit listeners. Index exceeds size.");
    return setNewListenerLike(index, buildListener(index));
  }
  public GatewaySpecFluent.ListenersNested<A> editFirstListener() {
    if (listeners.size() == 0) throw new RuntimeException("Can't edit first listeners. The list is empty.");
    return setNewListenerLike(0, buildListener(0));
  }
  public GatewaySpecFluent.ListenersNested<A> editLastListener() {
    int index = listeners.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last listeners. The list is empty.");
    return setNewListenerLike(index, buildListener(index));
  }
  public GatewaySpecFluent.ListenersNested<A> editMatchingListener(Predicate<ListenerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<listeners.size();i++) { 
    if (predicate.test(listeners.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching listeners. No match found.");
    return setNewListenerLike(index, buildListener(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GatewaySpecFluentImpl that = (GatewaySpecFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (gatewayClassName != null ? !gatewayClassName.equals(that.gatewayClassName) :that.gatewayClassName != null) return false;
    if (listeners != null ? !listeners.equals(that.listeners) :that.listeners != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  gatewayClassName,  listeners,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (gatewayClassName != null) { sb.append("gatewayClassName:"); sb.append(gatewayClassName + ","); }
    if (listeners != null && !listeners.isEmpty()) { sb.append("listeners:"); sb.append(listeners + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AddressesNestedImpl<N> extends GatewayAddressFluentImpl<GatewaySpecFluent.AddressesNested<N>> implements GatewaySpecFluent.AddressesNested<N>,Nested<N>{
    AddressesNestedImpl(Integer index,GatewayAddress item) {
      this.index = index;
      this.builder = new GatewayAddressBuilder(this, item);
    }
    AddressesNestedImpl() {
      this.index = -1;
      this.builder = new GatewayAddressBuilder(this);
    }
    GatewayAddressBuilder builder;
    Integer index;
    public N and() {
      return (N) GatewaySpecFluentImpl.this.setToAddresses(index,builder.build());
    }
    public N endAddress() {
      return and();
    }
    
  }
  class ListenersNestedImpl<N> extends ListenerFluentImpl<GatewaySpecFluent.ListenersNested<N>> implements GatewaySpecFluent.ListenersNested<N>,Nested<N>{
    ListenersNestedImpl(Integer index,Listener item) {
      this.index = index;
      this.builder = new ListenerBuilder(this, item);
    }
    ListenersNestedImpl() {
      this.index = -1;
      this.builder = new ListenerBuilder(this);
    }
    ListenerBuilder builder;
    Integer index;
    public N and() {
      return (N) GatewaySpecFluentImpl.this.setToListeners(index,builder.build());
    }
    public N endListener() {
      return and();
    }
    
  }
  
}