package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StorageVersionBuilder extends StorageVersionFluent<StorageVersionBuilder> implements VisitableBuilder<StorageVersion,StorageVersionBuilder>{
  public StorageVersionBuilder() {
    this(new StorageVersion());
  }
  
  public StorageVersionBuilder(StorageVersionFluent<?> fluent) {
    this(fluent, new StorageVersion());
  }
  
  public StorageVersionBuilder(StorageVersionFluent<?> fluent,StorageVersion instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StorageVersionBuilder(StorageVersion instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StorageVersionFluent<?> fluent;
  
  public StorageVersion build() {
    StorageVersion buildable = new StorageVersion(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}