package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class QueuingConfigurationFluent<A extends QueuingConfigurationFluent<A>> extends BaseFluent<A>{
  public QueuingConfigurationFluent() {
  }
  
  public QueuingConfigurationFluent(QueuingConfiguration instance) {
    this.copyInstance(instance);
  }
  private Integer handSize;
  private Integer queueLengthLimit;
  private Integer queues;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(QueuingConfiguration instance) {
    instance = (instance != null ? instance : new QueuingConfiguration());
  
    if (instance != null) {
        this.withHandSize(instance.getHandSize());
        this.withQueueLengthLimit(instance.getQueueLengthLimit());
        this.withQueues(instance.getQueues());
        this.withHandSize(instance.getHandSize());
        this.withQueueLengthLimit(instance.getQueueLengthLimit());
        this.withQueues(instance.getQueues());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public Integer getHandSize() {
    return this.handSize;
  }
  
  public A withHandSize(Integer handSize) {
    this.handSize=handSize; return (A) this;
  }
  
  public boolean hasHandSize() {
    return this.handSize != null;
  }
  
  public Integer getQueueLengthLimit() {
    return this.queueLengthLimit;
  }
  
  public A withQueueLengthLimit(Integer queueLengthLimit) {
    this.queueLengthLimit=queueLengthLimit; return (A) this;
  }
  
  public boolean hasQueueLengthLimit() {
    return this.queueLengthLimit != null;
  }
  
  public Integer getQueues() {
    return this.queues;
  }
  
  public A withQueues(Integer queues) {
    this.queues=queues; return (A) this;
  }
  
  public boolean hasQueues() {
    return this.queues != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    QueuingConfigurationFluent that = (QueuingConfigurationFluent) o;
    if (!java.util.Objects.equals(handSize, that.handSize)) return false;
  
    if (!java.util.Objects.equals(queueLengthLimit, that.queueLengthLimit)) return false;
  
    if (!java.util.Objects.equals(queues, that.queues)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(handSize,  queueLengthLimit,  queues,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (handSize != null) { sb.append("handSize:"); sb.append(handSize + ","); }
    if (queueLengthLimit != null) { sb.append("queueLengthLimit:"); sb.append(queueLengthLimit + ","); }
    if (queues != null) { sb.append("queues:"); sb.append(queues + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}