package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionSpecBuilder extends StorageVersionSpecFluent<StorageVersionSpecBuilder> implements VisitableBuilder<StorageVersionSpec,StorageVersionSpecBuilder>{
  public StorageVersionSpecBuilder() {
    this(false);
  }
  public StorageVersionSpecBuilder(Boolean validationEnabled) {
    this(new StorageVersionSpec(), validationEnabled);
  }
  public StorageVersionSpecBuilder(StorageVersionSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionSpecBuilder(StorageVersionSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionSpec(), validationEnabled);
  }
  public StorageVersionSpecBuilder(StorageVersionSpecFluent<?> fluent,StorageVersionSpec instance) {
    this(fluent, instance, false);
  }
  public StorageVersionSpecBuilder(StorageVersionSpecFluent<?> fluent,StorageVersionSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageVersionSpec());

    if (instance != null) {
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionSpecBuilder(StorageVersionSpec instance) {
    this(instance,false);
  }
  public StorageVersionSpecBuilder(StorageVersionSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageVersionSpec());

    if (instance != null) {
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionSpec build() {
    StorageVersionSpec buildable = new StorageVersionSpec();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}