package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StorageVersionListBuilder extends StorageVersionListFluent<StorageVersionListBuilder> implements VisitableBuilder<StorageVersionList,StorageVersionListBuilder>{
  public StorageVersionListBuilder() {
    this(false);
  }
  public StorageVersionListBuilder(Boolean validationEnabled) {
    this(new StorageVersionList(), validationEnabled);
  }
  public StorageVersionListBuilder(StorageVersionListFluent<?> fluent) {
    this(fluent, false);
  }
  public StorageVersionListBuilder(StorageVersionListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StorageVersionList(), validationEnabled);
  }
  public StorageVersionListBuilder(StorageVersionListFluent<?> fluent,StorageVersionList instance) {
    this(fluent, instance, false);
  }
  public StorageVersionListBuilder(StorageVersionListFluent<?> fluent,StorageVersionList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StorageVersionList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StorageVersionListBuilder(StorageVersionList instance) {
    this(instance,false);
  }
  public StorageVersionListBuilder(StorageVersionList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StorageVersionList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StorageVersionListFluent<?> fluent;
  Boolean validationEnabled;
  public StorageVersionList build() {
    StorageVersionList buildable = new StorageVersionList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}