package io.fabric8.kubernetes.api.model.internal.apiserver.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServerStorageVersionBuilder extends ServerStorageVersionFluent<ServerStorageVersionBuilder> implements VisitableBuilder<ServerStorageVersion,ServerStorageVersionBuilder>{
  public ServerStorageVersionBuilder() {
    this(false);
  }
  public ServerStorageVersionBuilder(Boolean validationEnabled) {
    this(new ServerStorageVersion(), validationEnabled);
  }
  public ServerStorageVersionBuilder(ServerStorageVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public ServerStorageVersionBuilder(ServerStorageVersionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServerStorageVersion(), validationEnabled);
  }
  public ServerStorageVersionBuilder(ServerStorageVersionFluent<?> fluent,ServerStorageVersion instance) {
    this(fluent, instance, false);
  }
  public ServerStorageVersionBuilder(ServerStorageVersionFluent<?> fluent,ServerStorageVersion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServerStorageVersion());

    if (instance != null) {
      fluent.withApiServerID(instance.getApiServerID());
      fluent.withDecodableVersions(instance.getDecodableVersions());
      fluent.withEncodingVersion(instance.getEncodingVersion());
      fluent.withApiServerID(instance.getApiServerID());
      fluent.withDecodableVersions(instance.getDecodableVersions());
      fluent.withEncodingVersion(instance.getEncodingVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServerStorageVersionBuilder(ServerStorageVersion instance) {
    this(instance,false);
  }
  public ServerStorageVersionBuilder(ServerStorageVersion instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServerStorageVersion());

    if (instance != null) {
      this.withApiServerID(instance.getApiServerID());
      this.withDecodableVersions(instance.getDecodableVersions());
      this.withEncodingVersion(instance.getEncodingVersion());
      this.withApiServerID(instance.getApiServerID());
      this.withDecodableVersions(instance.getDecodableVersions());
      this.withEncodingVersion(instance.getEncodingVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServerStorageVersionFluent<?> fluent;
  Boolean validationEnabled;
  public ServerStorageVersion build() {
    ServerStorageVersion buildable = new ServerStorageVersion(fluent.getApiServerID(),fluent.getDecodableVersions(),fluent.getEncodingVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}