package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlowSchemaListBuilder extends FlowSchemaListFluentImpl<FlowSchemaListBuilder> implements VisitableBuilder<FlowSchemaList,FlowSchemaListBuilder>{
  public FlowSchemaListBuilder() {
    this(false);
  }
  public FlowSchemaListBuilder(Boolean validationEnabled) {
    this(new FlowSchemaList(), validationEnabled);
  }
  public FlowSchemaListBuilder(FlowSchemaListFluent<?> fluent) {
    this(fluent, false);
  }
  public FlowSchemaListBuilder(FlowSchemaListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FlowSchemaList(), validationEnabled);
  }
  public FlowSchemaListBuilder(FlowSchemaListFluent<?> fluent,FlowSchemaList instance) {
    this(fluent, instance, false);
  }
  public FlowSchemaListBuilder(FlowSchemaListFluent<?> fluent,FlowSchemaList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public FlowSchemaListBuilder(FlowSchemaList instance) {
    this(instance,false);
  }
  public FlowSchemaListBuilder(FlowSchemaList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  FlowSchemaListFluent<?> fluent;
  Boolean validationEnabled;
  public FlowSchemaList build() {
    FlowSchemaList buildable = new FlowSchemaList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}