package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourcePolicyRuleBuilder extends ResourcePolicyRuleFluentImpl<ResourcePolicyRuleBuilder> implements VisitableBuilder<ResourcePolicyRule,ResourcePolicyRuleBuilder>{
  public ResourcePolicyRuleBuilder() {
    this(false);
  }
  public ResourcePolicyRuleBuilder(Boolean validationEnabled) {
    this(new ResourcePolicyRule(), validationEnabled);
  }
  public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourcePolicyRule(), validationEnabled);
  }
  public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent,ResourcePolicyRule instance) {
    this(fluent, instance, false);
  }
  public ResourcePolicyRuleBuilder(ResourcePolicyRuleFluent<?> fluent,ResourcePolicyRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiGroups(instance.getApiGroups());
      fluent.withClusterScope(instance.getClusterScope());
      fluent.withNamespaces(instance.getNamespaces());
      fluent.withResources(instance.getResources());
      fluent.withVerbs(instance.getVerbs());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourcePolicyRuleBuilder(ResourcePolicyRule instance) {
    this(instance,false);
  }
  public ResourcePolicyRuleBuilder(ResourcePolicyRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withClusterScope(instance.getClusterScope());
      this.withNamespaces(instance.getNamespaces());
      this.withResources(instance.getResources());
      this.withVerbs(instance.getVerbs());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourcePolicyRuleFluent<?> fluent;
  Boolean validationEnabled;
  public ResourcePolicyRule build() {
    ResourcePolicyRule buildable = new ResourcePolicyRule(fluent.getApiGroups(),fluent.getClusterScope(),fluent.getNamespaces(),fluent.getResources(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}