package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityLevelConfigurationSpecBuilder extends PriorityLevelConfigurationSpecFluentImpl<PriorityLevelConfigurationSpecBuilder> implements VisitableBuilder<PriorityLevelConfigurationSpec,PriorityLevelConfigurationSpecBuilder>{
  public PriorityLevelConfigurationSpecBuilder() {
    this(false);
  }
  public PriorityLevelConfigurationSpecBuilder(Boolean validationEnabled) {
    this(new PriorityLevelConfigurationSpec(), validationEnabled);
  }
  public PriorityLevelConfigurationSpecBuilder(PriorityLevelConfigurationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityLevelConfigurationSpecBuilder(PriorityLevelConfigurationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityLevelConfigurationSpec(), validationEnabled);
  }
  public PriorityLevelConfigurationSpecBuilder(PriorityLevelConfigurationSpecFluent<?> fluent,PriorityLevelConfigurationSpec instance) {
    this(fluent, instance, false);
  }
  public PriorityLevelConfigurationSpecBuilder(PriorityLevelConfigurationSpecFluent<?> fluent,PriorityLevelConfigurationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLimited(instance.getLimited());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PriorityLevelConfigurationSpecBuilder(PriorityLevelConfigurationSpec instance) {
    this(instance,false);
  }
  public PriorityLevelConfigurationSpecBuilder(PriorityLevelConfigurationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLimited(instance.getLimited());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PriorityLevelConfigurationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityLevelConfigurationSpec build() {
    PriorityLevelConfigurationSpec buildable = new PriorityLevelConfigurationSpec(fluent.getLimited(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}