package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityLevelConfigurationListBuilder extends PriorityLevelConfigurationListFluentImpl<PriorityLevelConfigurationListBuilder> implements VisitableBuilder<PriorityLevelConfigurationList,PriorityLevelConfigurationListBuilder>{
  public PriorityLevelConfigurationListBuilder() {
    this(false);
  }
  public PriorityLevelConfigurationListBuilder(Boolean validationEnabled) {
    this(new PriorityLevelConfigurationList(), validationEnabled);
  }
  public PriorityLevelConfigurationListBuilder(PriorityLevelConfigurationListFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityLevelConfigurationListBuilder(PriorityLevelConfigurationListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityLevelConfigurationList(), validationEnabled);
  }
  public PriorityLevelConfigurationListBuilder(PriorityLevelConfigurationListFluent<?> fluent,PriorityLevelConfigurationList instance) {
    this(fluent, instance, false);
  }
  public PriorityLevelConfigurationListBuilder(PriorityLevelConfigurationListFluent<?> fluent,PriorityLevelConfigurationList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PriorityLevelConfigurationListBuilder(PriorityLevelConfigurationList instance) {
    this(instance,false);
  }
  public PriorityLevelConfigurationListBuilder(PriorityLevelConfigurationList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PriorityLevelConfigurationListFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityLevelConfigurationList build() {
    PriorityLevelConfigurationList buildable = new PriorityLevelConfigurationList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}