package io.fabric8.kubernetes.api.model.flowcontrol.v1beta3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NonResourcePolicyRuleBuilder extends NonResourcePolicyRuleFluentImpl<NonResourcePolicyRuleBuilder> implements VisitableBuilder<NonResourcePolicyRule,NonResourcePolicyRuleBuilder>{
  public NonResourcePolicyRuleBuilder() {
    this(false);
  }
  public NonResourcePolicyRuleBuilder(Boolean validationEnabled) {
    this(new NonResourcePolicyRule(), validationEnabled);
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NonResourcePolicyRule(), validationEnabled);
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRuleFluent<?> fluent,NonResourcePolicyRule instance) {
    this(fluent, instance, false);
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRuleFluent<?> fluent,NonResourcePolicyRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
    fluent.withVerbs(instance.getVerbs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRule instance) {
    this(instance,false);
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNonResourceURLs(instance.getNonResourceURLs()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NonResourcePolicyRuleFluent<?> fluent;
  Boolean validationEnabled;
  public NonResourcePolicyRule build() {
    NonResourcePolicyRule buildable = new NonResourcePolicyRule(fluent.getNonResourceURLs(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}