package io.fabric8.kubernetes.api.model.flowcontrol.v1beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FlowSchemaBuilder extends FlowSchemaFluentImpl<FlowSchemaBuilder> implements VisitableBuilder<FlowSchema,FlowSchemaBuilder>{
  public FlowSchemaBuilder() {
    this(false);
  }
  public FlowSchemaBuilder(Boolean validationEnabled) {
    this(new FlowSchema(), validationEnabled);
  }
  public FlowSchemaBuilder(FlowSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public FlowSchemaBuilder(FlowSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new FlowSchema(), validationEnabled);
  }
  public FlowSchemaBuilder(FlowSchemaFluent<?> fluent,FlowSchema instance) {
    this(fluent, instance, false);
  }
  public FlowSchemaBuilder(FlowSchemaFluent<?> fluent,FlowSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FlowSchemaBuilder(FlowSchema instance) {
    this(instance,false);
  }
  public FlowSchemaBuilder(FlowSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  FlowSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public FlowSchema build() {
    FlowSchema buildable = new FlowSchema(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}