package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PriorityLevelConfigurationBuilder extends PriorityLevelConfigurationFluentImpl<PriorityLevelConfigurationBuilder> implements VisitableBuilder<PriorityLevelConfiguration,PriorityLevelConfigurationBuilder>{
  public PriorityLevelConfigurationBuilder() {
    this(false);
  }
  public PriorityLevelConfigurationBuilder(Boolean validationEnabled) {
    this(new PriorityLevelConfiguration(), validationEnabled);
  }
  public PriorityLevelConfigurationBuilder(PriorityLevelConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public PriorityLevelConfigurationBuilder(PriorityLevelConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PriorityLevelConfiguration(), validationEnabled);
  }
  public PriorityLevelConfigurationBuilder(PriorityLevelConfigurationFluent<?> fluent,PriorityLevelConfiguration instance) {
    this(fluent, instance, false);
  }
  public PriorityLevelConfigurationBuilder(PriorityLevelConfigurationFluent<?> fluent,PriorityLevelConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PriorityLevelConfigurationBuilder(PriorityLevelConfiguration instance) {
    this(instance,false);
  }
  public PriorityLevelConfigurationBuilder(PriorityLevelConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PriorityLevelConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public PriorityLevelConfiguration build() {
    PriorityLevelConfiguration buildable = new PriorityLevelConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}