package io.fabric8.kubernetes.api.model.flowcontrol.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyRulesWithSubjectsBuilder extends PolicyRulesWithSubjectsFluentImpl<PolicyRulesWithSubjectsBuilder> implements VisitableBuilder<PolicyRulesWithSubjects,PolicyRulesWithSubjectsBuilder>{
  public PolicyRulesWithSubjectsBuilder() {
    this(false);
  }
  public PolicyRulesWithSubjectsBuilder(Boolean validationEnabled) {
    this(new PolicyRulesWithSubjects(), validationEnabled);
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjectsFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjectsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PolicyRulesWithSubjects(), validationEnabled);
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjectsFluent<?> fluent,PolicyRulesWithSubjects instance) {
    this(fluent, instance, false);
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjectsFluent<?> fluent,PolicyRulesWithSubjects instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNonResourceRules(instance.getNonResourceRules()); 
    fluent.withResourceRules(instance.getResourceRules()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjects instance) {
    this(instance,false);
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjects instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNonResourceRules(instance.getNonResourceRules()); 
    this.withResourceRules(instance.getResourceRules()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  PolicyRulesWithSubjectsFluent<?> fluent;
  Boolean validationEnabled;
  public PolicyRulesWithSubjects build() {
    PolicyRulesWithSubjects buildable = new PolicyRulesWithSubjects(fluent.getNonResourceRules(),fluent.getResourceRules(),fluent.getSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}