package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourcePolicyRuleBuilder extends ResourcePolicyRuleFluentImpl<ResourcePolicyRuleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule,ResourcePolicyRuleBuilder>{
  public ResourcePolicyRuleBuilder() {
    this(false);
  }
  public ResourcePolicyRuleBuilder(Boolean validationEnabled) {
    this(new ResourcePolicyRule(), validationEnabled);
  }
  public ResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourcePolicyRule(), validationEnabled);
  }
  public ResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule instance) {
    this(fluent, instance, false);
  }
  public ResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroups(instance.getApiGroups()); 
    fluent.withClusterScope(instance.getClusterScope()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withResources(instance.getResources()); 
    fluent.withVerbs(instance.getVerbs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule instance) {
    this(instance,false);
  }
  public ResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroups(instance.getApiGroups()); 
    this.withClusterScope(instance.getClusterScope()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withResources(instance.getResources()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.ResourcePolicyRule build() {
    ResourcePolicyRule buildable = new ResourcePolicyRule(fluent.getApiGroups(),fluent.getClusterScope(),fluent.getNamespaces(),fluent.getResources(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}