package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PolicyRulesWithSubjectsBuilder extends PolicyRulesWithSubjectsFluentImpl<PolicyRulesWithSubjectsBuilder> implements VisitableBuilder<PolicyRulesWithSubjects,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjectsBuilder>{
  public PolicyRulesWithSubjectsBuilder() {
    this(false);
  }
  public PolicyRulesWithSubjectsBuilder(Boolean validationEnabled) {
    this(new PolicyRulesWithSubjects(), validationEnabled);
  }
  public PolicyRulesWithSubjectsBuilder(PolicyRulesWithSubjectsFluent<?> fluent) {
    this(fluent, false);
  }
  public PolicyRulesWithSubjectsBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjectsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new PolicyRulesWithSubjects(), validationEnabled);
  }
  public PolicyRulesWithSubjectsBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjectsFluent<?> fluent,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects instance) {
    this(fluent, instance, false);
  }
  public PolicyRulesWithSubjectsBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjectsFluent<?> fluent,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNonResourceRules(instance.getNonResourceRules()); 
    fluent.withResourceRules(instance.getResourceRules()); 
    fluent.withSubjects(instance.getSubjects()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public PolicyRulesWithSubjectsBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects instance) {
    this(instance,false);
  }
  public PolicyRulesWithSubjectsBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNonResourceRules(instance.getNonResourceRules()); 
    this.withResourceRules(instance.getResourceRules()); 
    this.withSubjects(instance.getSubjects()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjectsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.PolicyRulesWithSubjects build() {
    PolicyRulesWithSubjects buildable = new PolicyRulesWithSubjects(fluent.getNonResourceRules(),fluent.getResourceRules(),fluent.getSubjects());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}