package io.fabric8.kubernetes.api.model.flowcontrol.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NonResourcePolicyRuleBuilder extends NonResourcePolicyRuleFluentImpl<NonResourcePolicyRuleBuilder> implements VisitableBuilder<NonResourcePolicyRule,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRuleBuilder>{
  public NonResourcePolicyRuleBuilder() {
    this(false);
  }
  public NonResourcePolicyRuleBuilder(Boolean validationEnabled) {
    this(new NonResourcePolicyRule(), validationEnabled);
  }
  public NonResourcePolicyRuleBuilder(NonResourcePolicyRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public NonResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NonResourcePolicyRule(), validationEnabled);
  }
  public NonResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRule instance) {
    this(fluent, instance, false);
  }
  public NonResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
    fluent.withVerbs(instance.getVerbs()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NonResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRule instance) {
    this(instance,false);
  }
  public NonResourcePolicyRuleBuilder(io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNonResourceURLs(instance.getNonResourceURLs()); 
    this.withVerbs(instance.getVerbs()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.flowcontrol.v1beta1.NonResourcePolicyRule build() {
    NonResourcePolicyRule buildable = new NonResourcePolicyRule(fluent.getNonResourceURLs(),fluent.getVerbs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}