package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IngressLoadBalancerStatusFluent<A extends IngressLoadBalancerStatusFluent<A>> extends BaseFluent<A>{
  public IngressLoadBalancerStatusFluent() {
  }
  
  public IngressLoadBalancerStatusFluent(IngressLoadBalancerStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<IngressLoadBalancerIngressBuilder> ingress = new ArrayList<IngressLoadBalancerIngressBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IngressLoadBalancerStatus instance) {
    instance = (instance != null ? instance : new IngressLoadBalancerStatus());
    if (instance != null) {
          this.withIngress(instance.getIngress());
          this.withIngress(instance.getIngress());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToIngress(int index,IngressLoadBalancerIngress item) {
    if (this.ingress == null) {this.ingress = new ArrayList<IngressLoadBalancerIngressBuilder>();}
    IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").add(index, builder); ingress.add(index, builder);}
    return (A)this;
  }
  
  public A setToIngress(int index,IngressLoadBalancerIngress item) {
    if (this.ingress == null) {this.ingress = new ArrayList<IngressLoadBalancerIngressBuilder>();}
    IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").set(index, builder); ingress.set(index, builder);}
    return (A)this;
  }
  
  public A addToIngress(io.fabric8.kubernetes.api.model.extensions.IngressLoadBalancerIngress... items) {
    if (this.ingress == null) {this.ingress = new ArrayList<IngressLoadBalancerIngressBuilder>();}
    for (IngressLoadBalancerIngress item : items) {IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A addAllToIngress(Collection<IngressLoadBalancerIngress> items) {
    if (this.ingress == null) {this.ingress = new ArrayList<IngressLoadBalancerIngressBuilder>();}
    for (IngressLoadBalancerIngress item : items) {IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A removeFromIngress(io.fabric8.kubernetes.api.model.extensions.IngressLoadBalancerIngress... items) {
    if (this.ingress == null) return (A)this;
    for (IngressLoadBalancerIngress item : items) {IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIngress(Collection<IngressLoadBalancerIngress> items) {
    if (this.ingress == null) return (A)this;
    for (IngressLoadBalancerIngress item : items) {IngressLoadBalancerIngressBuilder builder = new IngressLoadBalancerIngressBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<IngressLoadBalancerIngressBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      IngressLoadBalancerIngressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<IngressLoadBalancerIngress> buildIngress() {
    return this.ingress != null ? build(ingress) : null;
  }
  
  public IngressLoadBalancerIngress buildIngress(int index) {
    return this.ingress.get(index).build();
  }
  
  public IngressLoadBalancerIngress buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  
  public IngressLoadBalancerIngress buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  
  public IngressLoadBalancerIngress buildMatchingIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
      for (IngressLoadBalancerIngressBuilder item : ingress) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
      for (IngressLoadBalancerIngressBuilder item : ingress) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIngress(List<IngressLoadBalancerIngress> ingress) {
    if (this.ingress != null) {
      this._visitables.get("ingress").clear();
    }
    if (ingress != null) {
        this.ingress = new ArrayList();
        for (IngressLoadBalancerIngress item : ingress) {
          this.addToIngress(item);
        }
    } else {
      this.ingress = null;
    }
    return (A) this;
  }
  
  public A withIngress(io.fabric8.kubernetes.api.model.extensions.IngressLoadBalancerIngress... ingress) {
    if (this.ingress != null) {this.ingress.clear(); _visitables.remove("ingress"); }
    if (ingress != null) {for (IngressLoadBalancerIngress item :ingress){ this.addToIngress(item);}} return (A) this;
  }
  
  public boolean hasIngress() {
    return this.ingress != null && !this.ingress.isEmpty();
  }
  
  public IngressNested<A> addNewIngress() {
    return new IngressNested(-1, null);
  }
  
  public IngressNested<A> addNewIngressLike(IngressLoadBalancerIngress item) {
    return new IngressNested(-1, item);
  }
  
  public IngressNested<A> setNewIngressLike(int index,IngressLoadBalancerIngress item) {
    return new IngressNested(index, item);
  }
  
  public IngressNested<A> editIngress(int index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  
  public IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editMatchingIngress(Predicate<IngressLoadBalancerIngressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IngressLoadBalancerStatusFluent that = (IngressLoadBalancerStatusFluent) o;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(ingress,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class IngressNested<N> extends IngressLoadBalancerIngressFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(int index,IngressLoadBalancerIngress item) {
      this.index = index;
      this.builder = new IngressLoadBalancerIngressBuilder(this, item);
    }
    IngressLoadBalancerIngressBuilder builder;
    int index;
    
    public N and() {
      return (N) IngressLoadBalancerStatusFluent.this.setToIngress(index,builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }

}