package io.fabric8.kubernetes.api.model.extensions;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class DeploymentSpecFluent<A extends DeploymentSpecFluent<A>> extends BaseFluent<A>{
  public DeploymentSpecFluent() {
  }
  
  public DeploymentSpecFluent(DeploymentSpec instance) {
    this.copyInstance(instance);
  }
  private Integer minReadySeconds;
  private Boolean paused;
  private Integer progressDeadlineSeconds;
  private Integer replicas;
  private Integer revisionHistoryLimit;
  private RollbackConfigBuilder rollbackTo;
  private LabelSelectorBuilder selector;
  private DeploymentStrategyBuilder strategy;
  private PodTemplateSpecBuilder template;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(DeploymentSpec instance) {
    instance = (instance != null ? instance : new DeploymentSpec());
  
    if (instance != null) {
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withRollbackTo(instance.getRollbackTo());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withMinReadySeconds(instance.getMinReadySeconds());
        this.withPaused(instance.getPaused());
        this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
        this.withReplicas(instance.getReplicas());
        this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
        this.withRollbackTo(instance.getRollbackTo());
        this.withSelector(instance.getSelector());
        this.withStrategy(instance.getStrategy());
        this.withTemplate(instance.getTemplate());
        this.withAdditionalProperties(instance.getAdditionalProperties());
      }
  }
  
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  
  public boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  
  public Boolean getPaused() {
    return this.paused;
  }
  
  public A withPaused(Boolean paused) {
    this.paused=paused; return (A) this;
  }
  
  public boolean hasPaused() {
    return this.paused != null;
  }
  
  public Integer getProgressDeadlineSeconds() {
    return this.progressDeadlineSeconds;
  }
  
  public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds) {
    this.progressDeadlineSeconds=progressDeadlineSeconds; return (A) this;
  }
  
  public boolean hasProgressDeadlineSeconds() {
    return this.progressDeadlineSeconds != null;
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  
  public boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  
  public RollbackConfig buildRollbackTo() {
    return this.rollbackTo!=null ?this.rollbackTo.build():null;
  }
  
  public A withRollbackTo(RollbackConfig rollbackTo) {
    _visitables.get("rollbackTo").remove(this.rollbackTo);
    if (rollbackTo!=null){ this.rollbackTo= new RollbackConfigBuilder(rollbackTo); _visitables.get("rollbackTo").add(this.rollbackTo);} else { this.rollbackTo = null; _visitables.get("rollbackTo").remove(this.rollbackTo); } return (A) this;
  }
  
  public boolean hasRollbackTo() {
    return this.rollbackTo != null;
  }
  
  public A withNewRollbackTo(Long revision) {
    return (A)withRollbackTo(new RollbackConfig(revision));
  }
  
  public RollbackToNested<A> withNewRollbackTo() {
    return new RollbackToNested(null);
  }
  
  public RollbackToNested<A> withNewRollbackToLike(RollbackConfig item) {
    return new RollbackToNested(item);
  }
  
  public RollbackToNested<A> editRollbackTo() {
    return withNewRollbackToLike(java.util.Optional.ofNullable(buildRollbackTo()).orElse(null));
  }
  
  public RollbackToNested<A> editOrNewRollbackTo() {
    return withNewRollbackToLike(java.util.Optional.ofNullable(buildRollbackTo()).orElse(new RollbackConfigBuilder().build()));
  }
  
  public RollbackToNested<A> editOrNewRollbackToLike(RollbackConfig item) {
    return withNewRollbackToLike(java.util.Optional.ofNullable(buildRollbackTo()).orElse(item));
  }
  
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public DeploymentStrategy buildStrategy() {
    return this.strategy!=null ?this.strategy.build():null;
  }
  
  public A withStrategy(DeploymentStrategy strategy) {
    _visitables.get("strategy").remove(this.strategy);
    if (strategy!=null){ this.strategy= new DeploymentStrategyBuilder(strategy); _visitables.get("strategy").add(this.strategy);} else { this.strategy = null; _visitables.get("strategy").remove(this.strategy); } return (A) this;
  }
  
  public boolean hasStrategy() {
    return this.strategy != null;
  }
  
  public StrategyNested<A> withNewStrategy() {
    return new StrategyNested(null);
  }
  
  public StrategyNested<A> withNewStrategyLike(DeploymentStrategy item) {
    return new StrategyNested(item);
  }
  
  public StrategyNested<A> editStrategy() {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(null));
  }
  
  public StrategyNested<A> editOrNewStrategy() {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(new DeploymentStrategyBuilder().build()));
  }
  
  public StrategyNested<A> editOrNewStrategyLike(DeploymentStrategy item) {
    return withNewStrategyLike(java.util.Optional.ofNullable(buildStrategy()).orElse(item));
  }
  
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DeploymentSpecFluent that = (DeploymentSpecFluent) o;
    if (!java.util.Objects.equals(minReadySeconds, that.minReadySeconds)) return false;
  
    if (!java.util.Objects.equals(paused, that.paused)) return false;
  
    if (!java.util.Objects.equals(progressDeadlineSeconds, that.progressDeadlineSeconds)) return false;
  
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
  
    if (!java.util.Objects.equals(revisionHistoryLimit, that.revisionHistoryLimit)) return false;
  
    if (!java.util.Objects.equals(rollbackTo, that.rollbackTo)) return false;
  
    if (!java.util.Objects.equals(selector, that.selector)) return false;
  
    if (!java.util.Objects.equals(strategy, that.strategy)) return false;
  
    if (!java.util.Objects.equals(template, that.template)) return false;
  
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
  
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  paused,  progressDeadlineSeconds,  replicas,  revisionHistoryLimit,  rollbackTo,  selector,  strategy,  template,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (paused != null) { sb.append("paused:"); sb.append(paused + ","); }
    if (progressDeadlineSeconds != null) { sb.append("progressDeadlineSeconds:"); sb.append(progressDeadlineSeconds + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (rollbackTo != null) { sb.append("rollbackTo:"); sb.append(rollbackTo + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (strategy != null) { sb.append("strategy:"); sb.append(strategy + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPaused() {
    return withPaused(true);
  }
  public class RollbackToNested<N> extends RollbackConfigFluent<RollbackToNested<N>> implements Nested<N>{
    RollbackToNested(RollbackConfig item) {
      this.builder = new RollbackConfigBuilder(this, item);
    }
    RollbackConfigBuilder builder;
    
    public N and() {
      return (N) DeploymentSpecFluent.this.withRollbackTo(builder.build());
    }
    
    public N endRollbackTo() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) DeploymentSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class StrategyNested<N> extends DeploymentStrategyFluent<StrategyNested<N>> implements Nested<N>{
    StrategyNested(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyBuilder builder;
    
    public N and() {
      return (N) DeploymentSpecFluent.this.withStrategy(builder.build());
    }
    
    public N endStrategy() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) DeploymentSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}