package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyStatusBuilder extends NetworkPolicyStatusFluentImpl<NetworkPolicyStatusBuilder> implements VisitableBuilder<NetworkPolicyStatus,NetworkPolicyStatusBuilder>{
  public NetworkPolicyStatusBuilder() {
    this(false);
  }
  public NetworkPolicyStatusBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyStatus(), validationEnabled);
  }
  public NetworkPolicyStatusBuilder(NetworkPolicyStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyStatusBuilder(NetworkPolicyStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicyStatus(), validationEnabled);
  }
  public NetworkPolicyStatusBuilder(NetworkPolicyStatusFluent<?> fluent,NetworkPolicyStatus instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyStatusBuilder(NetworkPolicyStatusFluent<?> fluent,NetworkPolicyStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyStatusBuilder(NetworkPolicyStatus instance) {
    this(instance,false);
  }
  public NetworkPolicyStatusBuilder(NetworkPolicyStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyStatusFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicyStatus build() {
    NetworkPolicyStatus buildable = new NetworkPolicyStatus(fluent.getConditions());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}