package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkPolicyPortFluentImpl<A extends NetworkPolicyPortFluent<A>> extends BaseFluent<A> implements NetworkPolicyPortFluent<A>{
  public NetworkPolicyPortFluentImpl() {
  }
  public NetworkPolicyPortFluentImpl(NetworkPolicyPort instance) {
    if (instance != null) {
      this.withEndPort(instance.getEndPort());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer endPort;
  private IntOrStringBuilder port;
  private String protocol;
  private Map<String,Object> additionalProperties;
  public Integer getEndPort() {
    return this.endPort;
  }
  public A withEndPort(Integer endPort) {
    this.endPort=endPort; return (A) this;
  }
  public Boolean hasEndPort() {
    return this.endPort != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getPort() {
    return this.port!=null ?this.port.build():null;
  }
  public IntOrString buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(IntOrString port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Object value) {
    return (A)withPort(new IntOrString(value));
  }
  public NetworkPolicyPortFluentImpl.PortNested<A> withNewPort() {
    return new NetworkPolicyPortFluentImpl.PortNestedImpl();
  }
  public NetworkPolicyPortFluentImpl.PortNested<A> withNewPortLike(IntOrString item) {
    return new NetworkPolicyPortFluentImpl.PortNestedImpl(item);
  }
  public NetworkPolicyPortFluentImpl.PortNested<A> editPort() {
    return withNewPortLike(getPort());
  }
  public NetworkPolicyPortFluentImpl.PortNested<A> editOrNewPort() {
    return withNewPortLike(getPort() != null ? getPort(): new IntOrStringBuilder().build());
  }
  public NetworkPolicyPortFluentImpl.PortNested<A> editOrNewPortLike(IntOrString item) {
    return withNewPortLike(getPort() != null ? getPort(): item);
  }
  public String getProtocol() {
    return this.protocol;
  }
  public A withProtocol(String protocol) {
    this.protocol=protocol; return (A) this;
  }
  public Boolean hasProtocol() {
    return this.protocol != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyPortFluentImpl that = (NetworkPolicyPortFluentImpl) o;
    if (!java.util.Objects.equals(endPort, that.endPort)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(protocol, that.protocol)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(endPort,  port,  protocol,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (endPort != null) { sb.append("endPort:"); sb.append(endPort + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (protocol != null) { sb.append("protocol:"); sb.append(protocol + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PortNestedImpl<N> extends IntOrStringFluentImpl<NetworkPolicyPortFluentImpl.PortNested<N>> implements NetworkPolicyPortFluentImpl.PortNested<N>,Nested<N>{
    PortNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    PortNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) NetworkPolicyPortFluentImpl.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}