package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressLoadBalancerStatusBuilder extends IngressLoadBalancerStatusFluentImpl<IngressLoadBalancerStatusBuilder> implements VisitableBuilder<IngressLoadBalancerStatus,IngressLoadBalancerStatusBuilder>{
  public IngressLoadBalancerStatusBuilder() {
    this(false);
  }
  public IngressLoadBalancerStatusBuilder(Boolean validationEnabled) {
    this(new IngressLoadBalancerStatus(), validationEnabled);
  }
  public IngressLoadBalancerStatusBuilder(IngressLoadBalancerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressLoadBalancerStatusBuilder(IngressLoadBalancerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressLoadBalancerStatus(), validationEnabled);
  }
  public IngressLoadBalancerStatusBuilder(IngressLoadBalancerStatusFluent<?> fluent,IngressLoadBalancerStatus instance) {
    this(fluent, instance, false);
  }
  public IngressLoadBalancerStatusBuilder(IngressLoadBalancerStatusFluent<?> fluent,IngressLoadBalancerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withIngress(instance.getIngress());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressLoadBalancerStatusBuilder(IngressLoadBalancerStatus instance) {
    this(instance,false);
  }
  public IngressLoadBalancerStatusBuilder(IngressLoadBalancerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withIngress(instance.getIngress());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressLoadBalancerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IngressLoadBalancerStatus build() {
    IngressLoadBalancerStatus buildable = new IngressLoadBalancerStatus(fluent.getIngress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}