package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetSpecBuilder extends DaemonSetSpecFluentImpl<DaemonSetSpecBuilder> implements VisitableBuilder<DaemonSetSpec,DaemonSetSpecBuilder>{
  public DaemonSetSpecBuilder() {
    this(false);
  }
  public DaemonSetSpecBuilder(Boolean validationEnabled) {
    this(new DaemonSetSpec(), validationEnabled);
  }
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonSetSpec(), validationEnabled);
  }
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,DaemonSetSpec instance) {
    this(fluent, instance, false);
  }
  public DaemonSetSpecBuilder(DaemonSetSpecFluent<?> fluent,DaemonSetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withSelector(instance.getSelector());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTemplateGeneration(instance.getTemplateGeneration());
      fluent.withUpdateStrategy(instance.getUpdateStrategy());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetSpecBuilder(DaemonSetSpec instance) {
    this(instance,false);
  }
  public DaemonSetSpecBuilder(DaemonSetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSelector(instance.getSelector());
      this.withTemplate(instance.getTemplate());
      this.withTemplateGeneration(instance.getTemplateGeneration());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DaemonSetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonSetSpec build() {
    DaemonSetSpec buildable = new DaemonSetSpec(fluent.getMinReadySeconds(),fluent.getRevisionHistoryLimit(),fluent.getSelector(),fluent.getTemplate(),fluent.getTemplateGeneration(),fluent.getUpdateStrategy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}