package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetStatusBuilder extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder> implements VisitableBuilder<ReplicaSetStatus,ReplicaSetStatusBuilder>{
  public ReplicaSetStatusBuilder() {
    this(false);
  }
  public ReplicaSetStatusBuilder(Boolean validationEnabled) {
    this(new ReplicaSetStatus(), validationEnabled);
  }
  public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicaSetStatus(), validationEnabled);
  }
  public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent,ReplicaSetStatus instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetStatusBuilder(ReplicaSetStatusFluent<?> fluent,ReplicaSetStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withConditions(instance.getConditions());
      fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetStatusBuilder(ReplicaSetStatus instance) {
    this(instance,false);
  }
  public ReplicaSetStatusBuilder(ReplicaSetStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withConditions(instance.getConditions());
      this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReplicaSetStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicaSetStatus build() {
    ReplicaSetStatus buildable = new ReplicaSetStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}