package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentSpecBuilder extends DeploymentSpecFluentImpl<DeploymentSpecBuilder> implements VisitableBuilder<DeploymentSpec,DeploymentSpecBuilder>{
  public DeploymentSpecBuilder() {
    this(false);
  }
  public DeploymentSpecBuilder(Boolean validationEnabled) {
    this(new DeploymentSpec(), validationEnabled);
  }
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentSpec(), validationEnabled);
  }
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent,DeploymentSpec instance) {
    this(fluent, instance, false);
  }
  public DeploymentSpecBuilder(DeploymentSpecFluent<?> fluent,DeploymentSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withPaused(instance.getPaused());
      fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
      fluent.withReplicas(instance.getReplicas());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withRollbackTo(instance.getRollbackTo());
      fluent.withSelector(instance.getSelector());
      fluent.withStrategy(instance.getStrategy());
      fluent.withTemplate(instance.getTemplate());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentSpecBuilder(DeploymentSpec instance) {
    this(instance,false);
  }
  public DeploymentSpecBuilder(DeploymentSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withPaused(instance.getPaused());
      this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());
      this.withReplicas(instance.getReplicas());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withRollbackTo(instance.getRollbackTo());
      this.withSelector(instance.getSelector());
      this.withStrategy(instance.getStrategy());
      this.withTemplate(instance.getTemplate());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentSpecFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentSpec build() {
    DeploymentSpec buildable = new DeploymentSpec(fluent.getMinReadySeconds(),fluent.getPaused(),fluent.getProgressDeadlineSeconds(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.getRollbackTo(),fluent.getSelector(),fluent.getStrategy(),fluent.getTemplate());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}