package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressBackendFluentImpl<A extends IngressBackendFluent<A>> extends BaseFluent<A> implements IngressBackendFluent<A>{
  public IngressBackendFluentImpl() {
  }
  public IngressBackendFluentImpl(IngressBackend instance) {
    this.withResource(instance.getResource()); 
    this.withServiceName(instance.getServiceName()); 
    this.withServicePort(instance.getServicePort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private TypedLocalObjectReference resource;
  private String serviceName;
  private IntOrStringBuilder servicePort;
  private Map<String,Object> additionalProperties;
  public TypedLocalObjectReference getResource() {
    return this.resource;
  }
  public A withResource(TypedLocalObjectReference resource) {
    this.resource=resource; return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public A withNewResource(String apiGroup,String kind,String name) {
    return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
  }
  public String getServiceName() {
    return this.serviceName;
  }
  public A withServiceName(String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  public Boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildServicePort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IntOrString getServicePort() {
    return this.servicePort!=null ?this.servicePort.build():null;
  }
  public IntOrString buildServicePort() {
    return this.servicePort!=null ?this.servicePort.build():null;
  }
  public A withServicePort(IntOrString servicePort) {
    _visitables.get("servicePort").remove(this.servicePort);
    if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.get("servicePort").add(this.servicePort);} else { this.servicePort = null; _visitables.get("servicePort").remove(this.servicePort); } return (A) this;
  }
  public Boolean hasServicePort() {
    return this.servicePort != null;
  }
  public A withNewServicePort(Object value) {
    return (A)withServicePort(new IntOrString(value));
  }
  public IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
    return new IngressBackendFluentImpl.ServicePortNestedImpl();
  }
  public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item) {
    return new IngressBackendFluentImpl.ServicePortNestedImpl(item);
  }
  public IngressBackendFluent.ServicePortNested<A> editServicePort() {
    return withNewServicePortLike(getServicePort());
  }
  public IngressBackendFluent.ServicePortNested<A> editOrNewServicePort() {
    return withNewServicePortLike(getServicePort() != null ? getServicePort(): new IntOrStringBuilder().build());
  }
  public IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
    return withNewServicePortLike(getServicePort() != null ? getServicePort(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
    if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
    if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
    if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(resource,  serviceName,  servicePort,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (servicePort != null) { sb.append("servicePort:"); sb.append(servicePort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ServicePortNestedImpl<N> extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>> implements IngressBackendFluent.ServicePortNested<N>,Nested<N>{
    ServicePortNestedImpl(IntOrString item) {
      this.builder = new IntOrStringBuilder(this, item);
    }
    ServicePortNestedImpl() {
      this.builder = new IntOrStringBuilder(this);
    }
    IntOrStringBuilder builder;
    public N and() {
      return (N) IngressBackendFluentImpl.this.withServicePort(builder.build());
    }
    public N endServicePort() {
      return and();
    }
    
  }
  
}