package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DaemonSetStatusFluentImpl<A extends DaemonSetStatusFluent<A>> extends BaseFluent<A> implements DaemonSetStatusFluent<A>{
  public DaemonSetStatusFluentImpl() {
  }
  public DaemonSetStatusFluentImpl(DaemonSetStatus instance) {
    this.withCollisionCount(instance.getCollisionCount()); 
    this.withConditions(instance.getConditions()); 
    this.withCurrentNumberScheduled(instance.getCurrentNumberScheduled()); 
    this.withDesiredNumberScheduled(instance.getDesiredNumberScheduled()); 
    this.withNumberAvailable(instance.getNumberAvailable()); 
    this.withNumberMisscheduled(instance.getNumberMisscheduled()); 
    this.withNumberReady(instance.getNumberReady()); 
    this.withNumberUnavailable(instance.getNumberUnavailable()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withUpdatedNumberScheduled(instance.getUpdatedNumberScheduled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer collisionCount;
  private ArrayList<DaemonSetConditionBuilder> conditions = new ArrayList<DaemonSetConditionBuilder>();
  private Integer currentNumberScheduled;
  private Integer desiredNumberScheduled;
  private Integer numberAvailable;
  private Integer numberMisscheduled;
  private Integer numberReady;
  private Integer numberUnavailable;
  private Long observedGeneration;
  private Integer updatedNumberScheduled;
  private Map<String,Object> additionalProperties;
  public Integer getCollisionCount() {
    return this.collisionCount;
  }
  public A withCollisionCount(Integer collisionCount) {
    this.collisionCount=collisionCount; return (A) this;
  }
  public Boolean hasCollisionCount() {
    return this.collisionCount != null;
  }
  public A addToConditions(Integer index,DaemonSetCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DaemonSetConditionBuilder>();}
    DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,DaemonSetCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<DaemonSetConditionBuilder>();}
    DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DaemonSetConditionBuilder>();}
    for (DaemonSetCondition item : items) {DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<DaemonSetCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<DaemonSetConditionBuilder>();}
    for (DaemonSetCondition item : items) {DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition... items) {
    for (DaemonSetCondition item : items) {DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<DaemonSetCondition> items) {
    for (DaemonSetCondition item : items) {DaemonSetConditionBuilder builder = new DaemonSetConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<DaemonSetConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<DaemonSetConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      DaemonSetConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<DaemonSetCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<DaemonSetCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public DaemonSetCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public DaemonSetCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public DaemonSetCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public DaemonSetCondition buildMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
    for (DaemonSetConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
    for (DaemonSetConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<DaemonSetCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (DaemonSetCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.extensions.DaemonSetCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (DaemonSetCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public A addNewCondition(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)addToConditions(new DaemonSetCondition(lastTransitionTime, message, reason, status, type));
  }
  public DaemonSetStatusFluent.ConditionsNested<A> addNewCondition() {
    return new DaemonSetStatusFluentImpl.ConditionsNestedImpl();
  }
  public DaemonSetStatusFluent.ConditionsNested<A> addNewConditionLike(DaemonSetCondition item) {
    return new DaemonSetStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public DaemonSetStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,DaemonSetCondition item) {
    return new DaemonSetStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public DaemonSetStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DaemonSetStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public DaemonSetStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public DaemonSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<DaemonSetConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public Integer getCurrentNumberScheduled() {
    return this.currentNumberScheduled;
  }
  public A withCurrentNumberScheduled(Integer currentNumberScheduled) {
    this.currentNumberScheduled=currentNumberScheduled; return (A) this;
  }
  public Boolean hasCurrentNumberScheduled() {
    return this.currentNumberScheduled != null;
  }
  public Integer getDesiredNumberScheduled() {
    return this.desiredNumberScheduled;
  }
  public A withDesiredNumberScheduled(Integer desiredNumberScheduled) {
    this.desiredNumberScheduled=desiredNumberScheduled; return (A) this;
  }
  public Boolean hasDesiredNumberScheduled() {
    return this.desiredNumberScheduled != null;
  }
  public Integer getNumberAvailable() {
    return this.numberAvailable;
  }
  public A withNumberAvailable(Integer numberAvailable) {
    this.numberAvailable=numberAvailable; return (A) this;
  }
  public Boolean hasNumberAvailable() {
    return this.numberAvailable != null;
  }
  public Integer getNumberMisscheduled() {
    return this.numberMisscheduled;
  }
  public A withNumberMisscheduled(Integer numberMisscheduled) {
    this.numberMisscheduled=numberMisscheduled; return (A) this;
  }
  public Boolean hasNumberMisscheduled() {
    return this.numberMisscheduled != null;
  }
  public Integer getNumberReady() {
    return this.numberReady;
  }
  public A withNumberReady(Integer numberReady) {
    this.numberReady=numberReady; return (A) this;
  }
  public Boolean hasNumberReady() {
    return this.numberReady != null;
  }
  public Integer getNumberUnavailable() {
    return this.numberUnavailable;
  }
  public A withNumberUnavailable(Integer numberUnavailable) {
    this.numberUnavailable=numberUnavailable; return (A) this;
  }
  public Boolean hasNumberUnavailable() {
    return this.numberUnavailable != null;
  }
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration=observedGeneration; return (A) this;
  }
  public Boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  public Integer getUpdatedNumberScheduled() {
    return this.updatedNumberScheduled;
  }
  public A withUpdatedNumberScheduled(Integer updatedNumberScheduled) {
    this.updatedNumberScheduled=updatedNumberScheduled; return (A) this;
  }
  public Boolean hasUpdatedNumberScheduled() {
    return this.updatedNumberScheduled != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DaemonSetStatusFluentImpl that = (DaemonSetStatusFluentImpl) o;
    if (collisionCount != null ? !collisionCount.equals(that.collisionCount) :that.collisionCount != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (currentNumberScheduled != null ? !currentNumberScheduled.equals(that.currentNumberScheduled) :that.currentNumberScheduled != null) return false;
    if (desiredNumberScheduled != null ? !desiredNumberScheduled.equals(that.desiredNumberScheduled) :that.desiredNumberScheduled != null) return false;
    if (numberAvailable != null ? !numberAvailable.equals(that.numberAvailable) :that.numberAvailable != null) return false;
    if (numberMisscheduled != null ? !numberMisscheduled.equals(that.numberMisscheduled) :that.numberMisscheduled != null) return false;
    if (numberReady != null ? !numberReady.equals(that.numberReady) :that.numberReady != null) return false;
    if (numberUnavailable != null ? !numberUnavailable.equals(that.numberUnavailable) :that.numberUnavailable != null) return false;
    if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
    if (updatedNumberScheduled != null ? !updatedNumberScheduled.equals(that.updatedNumberScheduled) :that.updatedNumberScheduled != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(collisionCount,  conditions,  currentNumberScheduled,  desiredNumberScheduled,  numberAvailable,  numberMisscheduled,  numberReady,  numberUnavailable,  observedGeneration,  updatedNumberScheduled,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (collisionCount != null) { sb.append("collisionCount:"); sb.append(collisionCount + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (currentNumberScheduled != null) { sb.append("currentNumberScheduled:"); sb.append(currentNumberScheduled + ","); }
    if (desiredNumberScheduled != null) { sb.append("desiredNumberScheduled:"); sb.append(desiredNumberScheduled + ","); }
    if (numberAvailable != null) { sb.append("numberAvailable:"); sb.append(numberAvailable + ","); }
    if (numberMisscheduled != null) { sb.append("numberMisscheduled:"); sb.append(numberMisscheduled + ","); }
    if (numberReady != null) { sb.append("numberReady:"); sb.append(numberReady + ","); }
    if (numberUnavailable != null) { sb.append("numberUnavailable:"); sb.append(numberUnavailable + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (updatedNumberScheduled != null) { sb.append("updatedNumberScheduled:"); sb.append(updatedNumberScheduled + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends DaemonSetConditionFluentImpl<DaemonSetStatusFluent.ConditionsNested<N>> implements DaemonSetStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,DaemonSetCondition item) {
      this.index = index;
      this.builder = new DaemonSetConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new DaemonSetConditionBuilder(this);
    }
    DaemonSetConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) DaemonSetStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}