package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonSetConditionBuilder extends DaemonSetConditionFluentImpl<DaemonSetConditionBuilder> implements VisitableBuilder<DaemonSetCondition,DaemonSetConditionBuilder>{
  public DaemonSetConditionBuilder() {
    this(false);
  }
  public DaemonSetConditionBuilder(Boolean validationEnabled) {
    this(new DaemonSetCondition(), validationEnabled);
  }
  public DaemonSetConditionBuilder(DaemonSetConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonSetConditionBuilder(DaemonSetConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonSetCondition(), validationEnabled);
  }
  public DaemonSetConditionBuilder(DaemonSetConditionFluent<?> fluent,DaemonSetCondition instance) {
    this(fluent, instance, false);
  }
  public DaemonSetConditionBuilder(DaemonSetConditionFluent<?> fluent,DaemonSetCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DaemonSetConditionBuilder(DaemonSetCondition instance) {
    this(instance,false);
  }
  public DaemonSetConditionBuilder(DaemonSetCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  DaemonSetConditionFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonSetCondition build() {
    DaemonSetCondition buildable = new DaemonSetCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}