package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyListBuilder extends NetworkPolicyListFluentImpl<NetworkPolicyListBuilder> implements VisitableBuilder<NetworkPolicyList,NetworkPolicyListBuilder>{
  public NetworkPolicyListBuilder() {
    this(false);
  }
  public NetworkPolicyListBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyList(), validationEnabled);
  }
  public NetworkPolicyListBuilder(NetworkPolicyListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyListBuilder(NetworkPolicyListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NetworkPolicyList(), validationEnabled);
  }
  public NetworkPolicyListBuilder(NetworkPolicyListFluent<?> fluent,NetworkPolicyList instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyListBuilder(NetworkPolicyListFluent<?> fluent,NetworkPolicyList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyListBuilder(NetworkPolicyList instance) {
    this(instance,false);
  }
  public NetworkPolicyListBuilder(NetworkPolicyList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  NetworkPolicyListFluent<?> fluent;
  Boolean validationEnabled;
  public NetworkPolicyList build() {
    NetworkPolicyList buildable = new NetworkPolicyList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}