package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RollingUpdateDaemonSetBuilder extends RollingUpdateDaemonSetFluentImpl<RollingUpdateDaemonSetBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSet,io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSetBuilder>{
  public RollingUpdateDaemonSetBuilder() {
    this(false);
  }
  public RollingUpdateDaemonSetBuilder(Boolean validationEnabled) {
    this(new RollingUpdateDaemonSet(), validationEnabled);
  }
  public RollingUpdateDaemonSetBuilder(RollingUpdateDaemonSetFluent<?> fluent) {
    this(fluent, false);
  }
  public RollingUpdateDaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new RollingUpdateDaemonSet(), validationEnabled);
  }
  public RollingUpdateDaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSetFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSet instance) {
    this(fluent, instance, false);
  }
  public RollingUpdateDaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSetFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxSurge(instance.getMaxSurge()); 
    fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RollingUpdateDaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSet instance) {
    this(instance,false);
  }
  public RollingUpdateDaemonSetBuilder(io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxSurge(instance.getMaxSurge()); 
    this.withMaxUnavailable(instance.getMaxUnavailable()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.RollingUpdateDaemonSet build() {
    RollingUpdateDaemonSet buildable = new RollingUpdateDaemonSet(fluent.getMaxSurge(),fluent.getMaxUnavailable());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}