package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicaSetStatusBuilder extends ReplicaSetStatusFluentImpl<ReplicaSetStatusBuilder> implements VisitableBuilder<ReplicaSetStatus,io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusBuilder>{
  public ReplicaSetStatusBuilder() {
    this(false);
  }
  public ReplicaSetStatusBuilder(Boolean validationEnabled) {
    this(new ReplicaSetStatus(), validationEnabled);
  }
  public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ReplicaSetStatus(), validationEnabled);
  }
  public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus instance) {
    this(fluent, instance, false);
  }
  public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus instance) {
    this(instance,false);
  }
  public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.extensions.ReplicaSetStatus build() {
    ReplicaSetStatus buildable = new ReplicaSetStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}